"""Data Scavenger Hunt: national collection of British art.

https://corgis-edu.github.io/corgis/csv/tate/
https://corgis-edu.github.io/corgis/json/tate/

Author: YOUR NAME
Version: THE DATE
"""

from pprint import pprint
from utils import read_csv, read_json

# ------------------------------------------------------------------------------
# Round 1: Using the CSV file
# ------------------------------------------------------------------------------


def ex1_csv():
    """What is the oldest work of art in the collection?"""
    oldest_year = 9999
    oldest_work = None
    names, data = read_csv("tate.csv")
    index = names.index("metadata.creation year")
    for row in data:
        year = int(row[index])
        # Is the year missing?
        if year == 0:
            continue
        # Is the year older?
        if year < oldest_year:
            oldest_year = year
            oldest_work = row

    # Print and return the answer
    pprint(oldest_work)
    return oldest_work


def ex2_csv():
    """On average, how many words in are a work's title?"""


def ex3_csv():
    """Which artist has the most works of art in the data?"""


def ex4_csv():
    """How many unique artists in the data are still alive?"""


# ------------------------------------------------------------------------------
# Round 2: Using the JSON file
# ------------------------------------------------------------------------------


def ex1_json():
    """What is the oldest work of art in the collection?"""
    oldest_year = 9999
    oldest_work = None
    data = read_json("tate.json")
    for item in data:
        year = item["metadata"]["creation year"]
        # Is the year missing?
        if year == 0:
            continue
        # Is the year older?
        if year < oldest_year:
            oldest_year = year
            oldest_work = item

    # Print and return the answer
    pprint(oldest_work)
    return oldest_work


def ex2_json():
    """On average, how many words in are a work's title?"""


def ex3_json():
    """Which artist has the most works of art in the data?"""


def ex4_json():
    """How many unique artists in the data are still alive?"""


# ------------------------------------------------------------------------------
# Test that each function works
# ------------------------------------------------------------------------------

if __name__ == "__main__":
    print("\n==== Exercise 1 ====\n")
    ex1_csv()
    print()
    ex1_json()

    print("\n==== Exercise 2 ====\n")
    ex2_csv()
    print()
    ex2_json()

    print("\n==== Exercise 3 ====\n")
    ex3_csv()
    print()
    ex3_json()

    print("\n==== Exercise 4 ====\n")
    ex4_csv()
    print()
    ex4_json()
