"""Data Scavenger Hunt: flights in the United States.

https://corgis-edu.github.io/corgis/csv/airlines/
https://corgis-edu.github.io/corgis/json/airlines/

Author: YOUR NAME
Version: THE DATE
"""

from pprint import pprint
from utils import read_csv, read_json

# ------------------------------------------------------------------------------
# Round 1: Using the CSV file
# ------------------------------------------------------------------------------


def ex1_csv():
    """How many unique airport codes are in the data?"""
    codes = set()
    names, data = read_csv("airlines.csv")
    index = names.index("Airport.Code")
    for row in data:
        codes.add(row[index])

    # Print and return the answer
    print(len(codes), "unique airport codes")
    return len(codes)


def ex2_csv():
    """What are the unique names of all the carriers?"""


def ex3_csv():
    """Which airport had the most flights in Dec 2015?"""


def ex4_csv():
    """Which had the most security delays in one month?"""


# ------------------------------------------------------------------------------
# Round 2: Using the JSON file
# ------------------------------------------------------------------------------


def ex1_json():
    """How many unique airport codes are in the data?"""
    codes = set()
    data = read_json("airlines.json")
    for item in data:
        codes.add(item["Airport"]["Code"])

    # Print and return the answer
    print(len(codes), "unique airport codes")
    return len(codes)


def ex2_json():
    """What are the unique names of all the carriers?"""


def ex3_json():
    """Which airport had the most flights in Dec 2015?"""


def ex4_json():
    """Which had the most security delays in one month?"""


# ------------------------------------------------------------------------------
# Test that each function works
# ------------------------------------------------------------------------------

if __name__ == "__main__":
    print("\n==== Exercise 1 ====\n")
    ex1_csv()
    print()
    ex1_json()

    print("\n==== Exercise 2 ====\n")
    ex2_csv()
    print()
    ex2_json()

    print("\n==== Exercise 3 ====\n")
    ex3_csv()
    print()
    ex3_json()

    print("\n==== Exercise 4 ====\n")
    ex4_csv()
    print()
    ex4_json()
