/*
 * hash_set.c
 *
 * Name: 
 */

#include "hash_set.h"


/**************************************
 * HELPER FUNCTIONS
 *************************************/

size_t hash(data_t value)
{
    // basic linear congruential generator (LCG) algorithm
    // (see https://en.wikipedia.org/wiki/Linear_congruential_generator)
    return (1103515245 * (size_t)(value) + 12345) % (1<<31);
}

bucket_t* malloc_buckets(size_t capacity)
{
    bucket_t *table = (bucket_t*)malloc(sizeof(bucket_t)*capacity);
    if (table == NULL) {
        printf("Out of memory!\n");
        exit(EXIT_FAILURE);
    }
    for (size_t i=0; i<capacity; i++) {
        table[i].is_empty = true;
        table[i].value = (data_t)0;
        table[i].next = NULL;
    }
    return table;
}

bucket_t* probe(bucket_t table[], size_t capacity, data_t value)
{
    return NULL;
}

void insert(bucket_t table[], size_t capacity, data_t value)
{
}


/**************************************
 * BASIC SET OPERATIONS
 *************************************/

void hash_set_init(hash_set_t *set)
{
    set->capacity = 4;
    set->table = malloc_buckets(set->capacity);
    set->size = 0;
}

size_t hash_set_size(hash_set_t *set)
{
    return set->size;
}

void hash_set_free(hash_set_t *set)
{
    free(set->table);
    set->table = NULL;
    set->capacity = 0;
    set->size = 0;
}

void hash_set_add(hash_set_t *set, data_t value)
{
}

bool hash_set_contains(hash_set_t *set, data_t value)
{
    return false;
}

