"""Flask-AppBuilder views that provide CRUD web interfaces for the models."""

import models

from flask_appbuilder import ModelView
from flask_appbuilder.models.sqla.interface import SQLAInterface


class Passenger(ModelView):
    datamodel = SQLAInterface(models.Passenger)
    route_base = '/passenger'
    list_title = 'Passengers'
    list_columns = ['passenger_id', 'booking_id', 'booking_ref', 'passenger_no', 'first_name', 'last_name', 'account_id', 'update_ts', 'age']


class Account(ModelView):
    datamodel = SQLAInterface(models.Account)
    route_base = '/account'
    list_title = 'Accounts'
    list_columns = ['account_id', 'login', 'first_name', 'last_name', 'frequent_flyer_id', 'update_ts']


class Phone(ModelView):
    datamodel = SQLAInterface(models.Phone)
    route_base = '/phone'
    list_title = 'Phones'
    list_columns = ['phone_id', 'account_id', 'phone', 'phone_type', 'primary_phone', 'update_ts']


class FrequentFlyer(ModelView):
    datamodel = SQLAInterface(models.FrequentFlyer)
    route_base = '/frequent_flyer'
    list_title = 'Frequent Flyers'
    list_columns = ['frequent_flyer_id', 'first_name', 'last_name', 'title', 'card_num', 'level', 'award_points', 'email', 'phone', 'update_ts']


class Booking(ModelView):
    datamodel = SQLAInterface(models.Booking)
    route_base = '/booking'
    list_title = 'Bookings'
    list_columns = ['booking_id', 'booking_ref', 'booking_name', 'account_id', 'email', 'phone', 'update_ts', 'price']


class BookingLeg(ModelView):
    datamodel = SQLAInterface(models.BookingLeg)
    route_base = '/booking_leg'
    list_title = 'Booking Legs'
    list_columns = ['booking_leg_id', 'booking_id', 'flight_id', 'leg_num', 'is_returning', 'update_ts']


class BoardingPass(ModelView):
    datamodel = SQLAInterface(models.BoardingPass)
    route_base = '/boarding_pass'
    list_title = 'Boarding Passes'
    list_columns = ['pass_id', 'passenger_id', 'booking_leg_id', 'seat', 'boarding_time', 'precheck', 'update_ts']


class Flight(ModelView):
    datamodel = SQLAInterface(models.Flight)
    route_base = '/flight'
    list_title = 'Flights'
    list_columns = ['flight_id', 'flight_no', 'scheduled_departure', 'scheduled_arrival', 'departure_airport', 'arrival_airport', 'status', 'aircraft_code', 'actual_departure', 'actual_arrival', 'update_ts']


class Airport(ModelView):
    datamodel = SQLAInterface(models.Airport)
    route_base = '/airport'
    list_title = 'Airports'
    list_columns = ['airport_code', 'airport_name', 'city', 'airport_tz', 'continent', 'iso_country', 'iso_region', 'intnl', 'update_ts']


class Aircraft(ModelView):
    datamodel = SQLAInterface(models.Aircraft)
    route_base = '/aircraft'
    list_title = 'Aircrafts'
    list_columns = ['model', 'range', 'class', 'velocity', 'code']
