"""SQLAlchemy model classes (database tables) generated by `sqlacodegen`."""

# NOTE Using flask_appbuilder.Model as the base class instead of Base.

import datetime
import decimal
from typing import Optional

from flask_appbuilder import Model
from sqlalchemy import BigInteger, Boolean, CHAR, DateTime, ForeignKeyConstraint, Index, Integer, Numeric, PrimaryKeyConstraint, Text, UniqueConstraint
from sqlalchemy.orm import Mapped, mapped_column, relationship


class Passenger(Model):
    __tablename__ = "passenger"
    __table_args__ = (
        ForeignKeyConstraint(["account_id"], ["account.account_id"], name="pass_account_id_fk"),
        ForeignKeyConstraint(["account_id"], ["account.account_id"], name="pass_frequent_flyer_id_fk"),
        ForeignKeyConstraint(["booking_id"], ["booking.booking_id"], name="pass_booking_id_fk"),
        PrimaryKeyConstraint("passenger_id", name="passenger_pkey"),
        Index("passenger_account_id", "account_id"),
        Index("passenger_booking_id", "booking_id"),
        Index("passenger_last_name", "last_name"),
        Index("passenger_last_name_lower_pattern")
    )

    passenger_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    booking_id: Mapped[int] = mapped_column(Integer, nullable=False)
    first_name: Mapped[str] = mapped_column(Text, nullable=False)
    last_name: Mapped[str] = mapped_column(Text, nullable=False)
    booking_ref: Mapped[Optional[str]] = mapped_column(Text)
    passenger_no: Mapped[Optional[int]] = mapped_column(Integer)
    account_id: Mapped[Optional[int]] = mapped_column(Integer)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))
    age: Mapped[Optional[int]] = mapped_column(Integer)

    account: Mapped[Optional["Account"]] = relationship("Account", foreign_keys=[account_id], back_populates="passenger")
    booking: Mapped["Booking"] = relationship("Booking", back_populates="passenger")
    boarding_pass: Mapped[list["BoardingPass"]] = relationship("BoardingPass", back_populates="passenger")


class Account(Model):
    __tablename__ = "account"
    __table_args__ = (
        ForeignKeyConstraint(["frequent_flyer_id"], ["frequent_flyer.frequent_flyer_id"], name="frequent_flyer_id_fk"),
        PrimaryKeyConstraint("account_id", name="account_pkey"),
        Index("account_domain_lower_pattern"),
        Index("account_frequent_flyer_id", "frequent_flyer_id"),
        Index("account_last_name", "last_name"),
        Index("account_last_name_lower"),
        Index("account_last_name_lower_pattern"),
        Index("account_login", "login"),
        Index("account_login_lower_pattern"),
        Index("account_to_text_id_pattern")
    )

    account_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    login: Mapped[str] = mapped_column(Text, nullable=False)
    first_name: Mapped[str] = mapped_column(Text, nullable=False)
    last_name: Mapped[str] = mapped_column(Text, nullable=False)
    frequent_flyer_id: Mapped[Optional[int]] = mapped_column(Integer)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    frequent_flyer: Mapped[Optional["FrequentFlyer"]] = relationship("FrequentFlyer", back_populates="account")
    booking: Mapped[list["Booking"]] = relationship("Booking", back_populates="account")
    phone: Mapped[list["Phone"]] = relationship("Phone", back_populates="account")
    passenger: Mapped[list["Passenger"]] = relationship("Passenger", foreign_keys="[Passenger.account_id]", back_populates="account")


class Phone(Model):
    __tablename__ = "phone"
    __table_args__ = (
        ForeignKeyConstraint(["account_id"], ["account.account_id"], name="phone_account_id_fk"),
        PrimaryKeyConstraint("phone_id", name="phone_pkey"),
        Index("phone_account_id", "account_id"),
        Index("phone_update_ts", "update_ts")
    )

    phone_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    account_id: Mapped[Optional[int]] = mapped_column(Integer)
    phone: Mapped[Optional[str]] = mapped_column(Text)
    phone_type: Mapped[Optional[str]] = mapped_column(Text)
    primary_phone: Mapped[Optional[bool]] = mapped_column(Boolean)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    account: Mapped[Optional["Account"]] = relationship("Account", back_populates="phone")


class FrequentFlyer(Model):
    __tablename__ = "frequent_flyer"
    __table_args__ = (
        PrimaryKeyConstraint("frequent_flyer_id", name="frequent_flyer_pkey"),
        Index("frequent_fl_last_name_lower"),
        Index("frequent_fl_last_name_lower_pattern")
    )

    frequent_flyer_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    first_name: Mapped[str] = mapped_column(Text, nullable=False)
    last_name: Mapped[str] = mapped_column(Text, nullable=False)
    title: Mapped[str] = mapped_column(Text, nullable=False)
    card_num: Mapped[str] = mapped_column(Text, nullable=False)
    level: Mapped[int] = mapped_column(Integer, nullable=False)
    award_points: Mapped[int] = mapped_column(Integer, nullable=False)
    email: Mapped[str] = mapped_column(Text, nullable=False)
    phone: Mapped[str] = mapped_column(Text, nullable=False)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    account: Mapped[list["Account"]] = relationship("Account", back_populates="frequent_flyer")


class Booking(Model):
    __tablename__ = "booking"
    __table_args__ = (
        ForeignKeyConstraint(["account_id"], ["account.account_id"], name="booking_account_id_fk"),
        PrimaryKeyConstraint("booking_id", name="booking_pkey"),
        UniqueConstraint("booking_ref", name="booking_booking_ref_key"),
        Index("booking_account_id", "account_id"),
        Index("booking_email_lower_pattern"),
        Index("booking_update_ts", "update_ts")
    )

    booking_id: Mapped[int] = mapped_column(BigInteger, primary_key=True)
    booking_ref: Mapped[str] = mapped_column(Text, nullable=False)
    email: Mapped[str] = mapped_column(Text, nullable=False)
    phone: Mapped[str] = mapped_column(Text, nullable=False)
    booking_name: Mapped[Optional[str]] = mapped_column(Text)
    account_id: Mapped[Optional[int]] = mapped_column(Integer)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))
    price: Mapped[Optional[decimal.Decimal]] = mapped_column(Numeric(7, 2))

    account: Mapped[Optional["Account"]] = relationship("Account", back_populates="booking")
    booking_leg: Mapped[list["BookingLeg"]] = relationship("BookingLeg", back_populates="booking")
    passenger: Mapped[list["Passenger"]] = relationship("Passenger", back_populates="booking")


class BookingLeg(Model):
    __tablename__ = "booking_leg"
    __table_args__ = (
        ForeignKeyConstraint(["booking_id"], ["booking.booking_id"], name="booking_id_fk"),
        ForeignKeyConstraint(["flight_id"], ["flight.flight_id"], name="flight_id_fk"),
        PrimaryKeyConstraint("booking_leg_id", name="booking_leg_pkey"),
        Index("booking_leg_booking_id", "booking_id"),
        Index("booking_leg_flight_id", "flight_id"),
        Index("booking_leg_update_ts", "update_ts")
    )

    booking_leg_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    booking_id: Mapped[int] = mapped_column(Integer, nullable=False)
    flight_id: Mapped[int] = mapped_column(Integer, nullable=False)
    leg_num: Mapped[Optional[int]] = mapped_column(Integer)
    is_returning: Mapped[Optional[bool]] = mapped_column(Boolean)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    booking: Mapped["Booking"] = relationship("Booking", back_populates="booking_leg")
    flight: Mapped["Flight"] = relationship("Flight", back_populates="booking_leg")
    boarding_pass: Mapped[list["BoardingPass"]] = relationship("BoardingPass", back_populates="booking_leg")


class BoardingPass(Model):
    __tablename__ = "boarding_pass"
    __table_args__ = (
        ForeignKeyConstraint(["booking_leg_id"], ["booking_leg.booking_leg_id"], name="booking_leg_id_fk"),
        ForeignKeyConstraint(["passenger_id"], ["passenger.passenger_id"], name="passenger_id_fk"),
        PrimaryKeyConstraint("pass_id", name="boarding_pass_pkey"),
        Index("boarding_pass_booking_leg_id", "booking_leg_id"),
        Index("boarding_pass_passenger_id", "passenger_id"),
        Index("boarding_pass_update_ts", "update_ts")
    )

    pass_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    passenger_id: Mapped[Optional[int]] = mapped_column(BigInteger)
    booking_leg_id: Mapped[Optional[int]] = mapped_column(BigInteger)
    seat: Mapped[Optional[str]] = mapped_column(Text)
    boarding_time: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))
    precheck: Mapped[Optional[bool]] = mapped_column(Boolean)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    booking_leg: Mapped[Optional["BookingLeg"]] = relationship("BookingLeg", back_populates="boarding_pass")
    passenger: Mapped[Optional["Passenger"]] = relationship("Passenger", back_populates="boarding_pass")


class Flight(Model):
    __tablename__ = "flight"
    __table_args__ = (
        ForeignKeyConstraint(["aircraft_code"], ["aircraft.code"], name="aircraft_code_fk"),
        ForeignKeyConstraint(["arrival_airport"], ["airport.airport_code"], name="arrival_airport_fk"),
        ForeignKeyConstraint(["departure_airport"], ["airport.airport_code"], name="departure_airport_fk"),
        PrimaryKeyConstraint("flight_id", name="flight_pkey"),
        Index("flight_actual_departure", "actual_departure"),
        Index("flight_actual_departure_not_null", "actual_departure"),
        Index("flight_arrival_airport", "arrival_airport"),
        Index("flight_canceled", "flight_id"),
        Index("flight_depart_arr_sched_dep", "departure_airport", "arrival_airport", "scheduled_departure"),
        Index("flight_depart_arr_sched_dep_inc_sched_arr", "departure_airport", "arrival_airport", "scheduled_departure"),
        Index("flight_depart_arr_sched_dep_sched_arr", "departure_airport", "arrival_airport", "scheduled_departure", "scheduled_arrival"),
        Index("flight_departure_airport", "departure_airport"),
        Index("flight_scheduled_departure", "scheduled_departure"),
        Index("flight_update_ts", "update_ts")
    )

    flight_id: Mapped[int] = mapped_column(Integer, primary_key=True)
    flight_no: Mapped[str] = mapped_column(Text, nullable=False)
    scheduled_departure: Mapped[datetime.datetime] = mapped_column(DateTime(True), nullable=False)
    scheduled_arrival: Mapped[datetime.datetime] = mapped_column(DateTime(True), nullable=False)
    departure_airport: Mapped[str] = mapped_column(CHAR(3), nullable=False)
    arrival_airport: Mapped[str] = mapped_column(CHAR(3), nullable=False)
    status: Mapped[str] = mapped_column(Text, nullable=False)
    aircraft_code: Mapped[str] = mapped_column(CHAR(3), nullable=False)
    actual_departure: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))
    actual_arrival: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    aircraft: Mapped["Aircraft"] = relationship("Aircraft", back_populates="flight")
    airport: Mapped["Airport"] = relationship("Airport", foreign_keys=[arrival_airport], back_populates="flight")
    airport_: Mapped["Airport"] = relationship("Airport", foreign_keys=[departure_airport], back_populates="flight_")
    booking_leg: Mapped[list["BookingLeg"]] = relationship("BookingLeg", back_populates="flight")


class Airport(Model):
    __tablename__ = "airport"
    __table_args__ = (
        PrimaryKeyConstraint("airport_code", name="airport_pkey"),
        Index("airport_city", "city")
    )

    airport_code: Mapped[str] = mapped_column(CHAR(3), primary_key=True)
    airport_name: Mapped[str] = mapped_column(Text, nullable=False)
    city: Mapped[str] = mapped_column(Text, nullable=False)
    airport_tz: Mapped[str] = mapped_column(Text, nullable=False)
    intnl: Mapped[bool] = mapped_column(Boolean, nullable=False)
    continent: Mapped[Optional[str]] = mapped_column(Text)
    iso_country: Mapped[Optional[str]] = mapped_column(Text)
    iso_region: Mapped[Optional[str]] = mapped_column(Text)
    update_ts: Mapped[Optional[datetime.datetime]] = mapped_column(DateTime(True))

    flight: Mapped[list["Flight"]] = relationship("Flight", foreign_keys="[Flight.arrival_airport]", back_populates="airport")
    flight_: Mapped[list["Flight"]] = relationship("Flight", foreign_keys="[Flight.departure_airport]", back_populates="airport_")


class Aircraft(Model):
    __tablename__ = "aircraft"
    __table_args__ = (
        PrimaryKeyConstraint("code", name="aircraft_pkey"),
    )

    range: Mapped[decimal.Decimal] = mapped_column(Numeric, nullable=False)
    class_: Mapped[int] = mapped_column("class", Integer, nullable=False)
    velocity: Mapped[decimal.Decimal] = mapped_column(Numeric, nullable=False)
    code: Mapped[str] = mapped_column(Text, primary_key=True)
    model: Mapped[Optional[str]] = mapped_column(Text)

    flight: Mapped[list["Flight"]] = relationship("Flight", back_populates="aircraft")
