"""Initialize the Flask application, database session, and appbuilder object."""

from flask import Flask
from flask_appbuilder import AppBuilder
from flask_sqlalchemy import SQLAlchemy
from menu import setup_menu

db = SQLAlchemy()
appbuilder = AppBuilder()

def create_app():
    app = Flask(__name__)
    app.config.from_object("config")

    with app.app_context():
        db.init_app(app)
        appbuilder.init_app(app, db.session)  # type: ignore
        setup_menu(appbuilder)

    return app
