const formEl = document.getElementById("grocery-form");

// Add a new event listener to the form's submit event
formEl.addEventListener("submit", addItemToList);

/**
 * Adds a new item to the grocery list table.
 */
function addItemToList(event) {
    event.preventDefault();

    // 1. Get the table body where new rows will be added
    const listBody = document.getElementById("list-body");
    
    // 2. Use document.getElementById() or document.querySelector() to get the input fields:
    const categorySelect = null; // TODO: Part 1
    const itemInput = document.getElementById("itemInput");
    const quantityInput = document.getElementById("quantityInput");
    const notesInput = document.getElementById("notesInput");

    // 3. Get the *values* from each of the input fields (Hint: use the .value property)
    const category = null; // TODO: Part 1
    const item = itemInput.value;
    const quantity = quantityInput.value;
    const notes = notesInput.value;

    // 4. Add the new row to the table body
    const newRowElement = makeRow(category, item, quantity, notes);
    listBody.appendChild(newRowElement);

    // TODO: Part 3 - Call appendToSavedList to update localStorage with the new item
}

/**
 * Returns a new table row element (<tr>) containing the values from the form fields.
 */
function makeRow(category, item, quantity, notes) {
    // 1. Create a new table row
    const newRow = document.createElement("tr");

    // 2. Create new table cells for each of the parameters and append them to the row

    // TODO: Part 1 - Create a new cell for the category

    const itemCell = document.createElement("td");
    itemCell.textContent = item;
    newRow.appendChild(itemCell);

    const quantityCell = document.createElement("td");
    quantityCell.textContent = quantity;
    newRow.appendChild(quantityCell);

    const notesCell = document.createElement("td");
    notesCell.textContent = notes;
    newRow.appendChild(notesCell);

    // 3. Return the new row element!
    return newRow;
}


//////// PART 3: Saving and Loading from localStorage ////////

function appendToSavedList(category, item, quantity, notes) {
    // Try to load the saved stringified array from localStorage.
    let savedList = localStorage.getItem("items");

    // If it exists, it will be a string (truthy), otherwise it will be null (falsy).
    if (savedList) {
        savedList = JSON.parse(savedList); // Parse the string back into an array
    } else {
        savedList = []; // Or make a new one
    }

    // TODO: Create a new object with the four parameters as properties

    // TODO: Append the new object to the array

    // TODO: Stringify the updated array into JSON
    
    // TODO: Save the stringified array back to localStorage
}

function loadList() {
    // TODO: Try to load the stringified array from localStorage

    // TODO: If it exists, parse it back into an array

    // TODO: Loop through each object in the array

    // TODO: Create a new row for each object and add it to the table (is there a function to do this?)
}


// TODO: Call loadList once the DOM is ready (Hint: use the DOMContentLoaded event)
