// Data source: https://github.com/bugnificent/accessibility-test
// The contents of five json files were copied into this array.
// Original data by Yusuf Aşık released under the MIT License.

const reports = [
  {
    "url": "https://cv.yusufasik.com/",
    "extensionVersion": "4.97.4",
    "axeVersion": "4.10.2",
    "standard": "WCAG 2.1 AA",
    "testingStartDate": "2025-01-21T15:02:16.758Z",
    "testingEndDate": "2025-01-21T15:02:16.758Z",
    "bestPracticesEnabled": true,
    "experimentalEnabled": false,
    "issueSummary": {
      "critical": 0,
      "serious": 24,
      "moderate": 69,
      "minor": 0,
      "bestPractices": 69,
      "needsReview": 0
    },
    "remainingTestingSummary": {
      "run": false
    },
    "igtSummary": [],
    "failedRules": [
      {
        "name": "color-contrast",
        "count": 23,
        "mode": "automated"
      },
      {
        "name": "scrollable-region-focusable",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "heading-order",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "landmark-one-main",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "region",
        "count": 67,
        "mode": "automated"
      }
    ],
    "needsReview": [],
    "source": {
      "productName": "axe-devtools-html",
      "productVersion": "4.97.4",
      "productComponentName": "extension-chrome"
    },
    "testDetails": {
      "testId": "",
      "axeVersion": "4.10.2",
      "engine": "axe-core",
      "standard": "WCAG 2.1 AA",
      "startDate": "2025-01-21T15:02:16.758Z",
      "endDate": "2025-01-21T15:02:16.758Z",
      "bestPracticesEnabled": true,
      "experimentalEnabled": false
    },
    "allIssues": [
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2024</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2024 — Now</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2024 — Now</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025 — 2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2022 — Now</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2019 — 2019</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2017 — 2017</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2015 — 2015</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(5) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(6) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2025</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(7) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2024</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(8) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2024</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(7) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2017 — 2019</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(7) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>2014 — 2017</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>LinkedIn</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>GitHub</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>Twitter</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(4) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>Website</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(5) > .Profile_year__KzJ4a > span"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.48 (foreground color: #888888, background color: #222222, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span>Email</span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "scrollable-region-focusable",
        "description": "Ensure elements that have scrollable content are accessible by keyboard",
        "help": "Scrollable region must have keyboard access",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/scrollable-region-focusable?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc > div:nth-child(2) > .Attachments_attachments__9iWjP > .Attachments_scrollableArea__BdwpE"
        ],
        "summary": "Fix any of the following:\\n  Element should have focusable content\\n  Element should be focusable",
        "source": "<div class=\"Attachments_scrollableArea__BdwpE\">",
        "tags": [
          "cat.keyboard",
          "wcag2a",
          "wcag211",
          "wcag213",
          "TTv5",
          "TT4.a",
          "EN-301-549",
          "EN-9.2.1.1",
          "EN-9.2.1.3"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "heading-order",
        "description": "Ensure the order of headings is semantically correct",
        "help": "Heading levels should only increase by one",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/heading-order?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_about__YfjU6 > h3"
        ],
        "summary": "Fix any of the following:\\n  Heading order invalid",
        "source": "<h3>About</h3>",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "landmark-one-main",
        "description": "Ensure the document has a main landmark",
        "help": "Document should have one main landmark",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/landmark-one-main?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "html"
        ],
        "summary": "Fix all of the following:\\n  Document does not have a main landmark",
        "source": "<html lang=\"en\">",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_profileHeader__G7z7R"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_profileHeader__G7z7R\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_about__YfjU6"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<section class=\"Profile_profileSection___hycX Profile_about__YfjU6\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > h3"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<h3>Awards</h3>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2024</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://learn.microsoft.com/en-us/users/velespit/achievements/fvjn3p6x\" target=\"_blank\">AI Security Testing from Microsoft</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(3) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > h3"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<h3>Volunteering</h3>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2024 — Now</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://testautomationu.applitools.com/me.html#yusuf-asik\" target=\"_blank\">Practitioner at Test Automation University</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_location__j4kBh"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_location__j4kBh\">Remote</div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2024 — Now</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://ieee-collabratec.ieee.org/rest/api/membership/certificate/MEMIEEE500\" target=\"_blank\">TEMS Member at IEEE</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_location__j4kBh"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_location__j4kBh\">Remote</div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(4) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3)"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_experience__8pQJc\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > h3"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<h3>Work Experience</h3>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2022 — Now</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.teleperformance.com/en-us/\" target=\"_blank\">Operations Customer Expert at Teleperformance</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_location__j4kBh"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_location__j4kBh\">Remote</div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2019 — 2019</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://istanbul.adalet.gov.tr/istanbul-adalet-sarayi\" target=\"_blank\">Intern at Istanbul Courthouse</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_location__j4kBh"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_location__j4kBh\">IST, Turkey</div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2017 — 2017</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"www.huqqa.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.huqqa.com\" target=\"_blank\">Intern at Atasay, HUQQA</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > div:nth-child(2) > .Profile_location__j4kBh"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_location__j4kBh\">IST, Turkey</div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(5) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4)"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_experience__8pQJc\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > h3"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<h3>Certifications</h3>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://academy.katalon.com/learning-path/practitioner-certification-fast-track/\" target=\"_blank\">Practitioner Level from Katalon</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://testautomationu.applitools.com/learningpaths.html?id=playwright-path\" target=\"_blank\">Advanced Playwright from Test Automation University</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(2) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"cydeo.com/\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://cydeo.com/\" target=\"_blank\">Java SDET from CYDEO</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(3) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\"><p>7 Months Full hands-on experience on Java Jr-Mid Level to AI-Enhanced Testing with approximately 1000 hours of experience with dozens of instructors who are experts in their fields, most of whom still continue to work in global companies.</p></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.udemy.com/course/database-testing-tutorial/\" target=\"_blank\">Learn SQL + Security(pen)Testing from Scratch from Udemy</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(6) > .Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(4) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\"><p>Step by step Tutorial to learn SQL and Web Security testing with real time examples</p></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(5) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experiences__Z2lAW > .Profile_experience__8pQJc:nth-child(5) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.istqb.org/certifications/certified-tester-foundation-level\" target=\"_blank\">Certified Tester v4.0 from ISTQB</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(5) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\"><p>ISTQB® is the leading global certification scheme in the field of software testing. The “Core” stream modules are valid for any technology/ methodology/ application domain and build on the Foundation Level.</p></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(6) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2025</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(6) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.linkedin.com/learning/certificates/0c0912f410adda4cd788e9e73bff2cec255d405fb6125a65144dbdfab27ccaf2\" target=\"_blank\">Software Architecture: Domain-Driven Design from LinkedIN</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(6) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(7) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2024</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"www.godaddy.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://www.godaddy.com\" target=\"_blank\">Data Protection and Security Awareness from GoDaddy</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(7) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\"><p>GoDaddy is leader in the Domain-Hosting and known for collaboration with Sucuri on Website Security and M365 Mail Security Products, New security certification that i added to my envanter with 100% score pass.</p></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(8) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>2024</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(8) > div:nth-child(2) > .Profile_title__DhufJ > a[href$=\"godaddy.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://godaddy.com\" target=\"_blank\">Global Anti-Harassment and Discrimination from GoDaddy</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(8) > div:nth-child(2) > .Profile_description__OMT9q"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_description__OMT9q\"><p>GoDaddy is leader in the Domain-Hosting and known for collaboration with Sucuri on Website Security and M365 Mail Security Products, New security certification that i added to my envanter with 100% score pass.</p></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(7)"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<section class=\"Profile_profileSection___hycX\">",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section:nth-child(8) > h3"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<h3>Contact</h3>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(1) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>LinkedIn</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(1) > div:nth-child(2) > .Profile_title__DhufJ > a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://linkedin.com/in/velespit\" target=\"_blank\">velespit</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(2) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>GitHub</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"velespitt\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://github.com/velespitt\" target=\"_blank\">velespitt</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(3) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>Twitter</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"testcanor\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://twitter.com/testcanor\" target=\"_blank\">testcanor</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(4) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>Website</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_experience__8pQJc:nth-child(4) > div:nth-child(2) > .Profile_title__DhufJ > a[href$=\"yusufasik.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"https://yusufasik.com\" target=\"_blank\">yusufasik.com</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".Profile_contacts__TQmml > .Profile_experience__8pQJc:nth-child(5) > .Profile_year__KzJ4a"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<div class=\"Profile_year__KzJ4a\"><span>Email</span></div>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href=\"mailto:contact@yusufasik.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<a href=\"mailto:contact@yusufasik.com\" target=\"_blank\">contact@yusufasik.com</a>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T15:02:16.758Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://cv.yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık",
        "screenshotURL": null
      }
    ]
  },
  {
    "url": "https://github.com/velespitt",
    "extensionVersion": "4.97.4",
    "axeVersion": "4.10.2",
    "standard": "WCAG 2.1 AA",
    "testingStartDate": "2025-01-21T19:11:27.077Z",
    "testingEndDate": "2025-01-21T19:11:27.077Z",
    "bestPracticesEnabled": true,
    "experimentalEnabled": false,
    "issueSummary": {
      "critical": 11,
      "serious": 10,
      "moderate": 0,
      "minor": 0,
      "bestPractices": 0,
      "needsReview": 0
    },
    "remainingTestingSummary": {
      "run": false
    },
    "igtSummary": [],
    "failedRules": [
      {
        "name": "image-alt",
        "count": 11,
        "mode": "automated"
      },
      {
        "name": "link-name",
        "count": 10,
        "mode": "automated"
      }
    ],
    "needsReview": [],
    "source": {
      "productName": "axe-devtools-html",
      "productVersion": "4.97.4",
      "productComponentName": "extension-chrome"
    },
    "testDetails": {
      "testId": "",
      "axeVersion": "4.10.2",
      "engine": "axe-core",
      "standard": "WCAG 2.1 AA",
      "startDate": "2025-01-21T19:11:27.077Z",
      "endDate": "2025-01-21T19:11:27.077Z",
      "bestPracticesEnabled": true,
      "experimentalEnabled": false
    },
    "allIssues": [
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[height=\"350\"][data-target=\"animated-image.originalImage\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/46e97275fd2db41b7f670c8d26d7e66e3b077bdbda626c0da7900681818312e3/68747470733a2f2f6d65646961312e74656e6f722e636f6d2f6d2f6d4e5242416c764745563441414141642f6e616e616d692d6a756a757473752d6b616973656e2e676966\" height=\"350\" data-canonical-src=\"https://media1.tenor.com/m/mNRBAlvGEV4AAAAd/nanami-jujutsu-kaisen.gif\" style=\"max-width: 100%; display: inline-block;\" data-target=\"animated-image.originalImage\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p:nth-child(6) > animated-image > a[rel=\"noopener noreferrer nofollow\"][data-target=\"animated-image.originalLink\"][target=\"_blank\"] > img[align=\"right\"][data-target=\"animated-image.originalImage\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img align=\"right\" src=\"https://user-images.githubusercontent.com/74038190/212748830-4c709398-a386-4761-84d7-9e10b98fbe6e.gif\" style=\"max-width: 100%; display: inline-block;\" data-target=\"animated-image.originalImage\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"devicon.dev\"] > img:nth-child(1)"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/7e6b82322c75f93e55084634af16070c18b046e356498b9cdb2b1eb75bfac7de/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d73656c656e69756d2c637970726573732c676865726b696e2c6a656e6b696e732c6d6176656e2c6a6573742c706f73746d616e\" data-canonical-src=\"https://skillicons.dev/icons?i=selenium,cypress,gherkin,jenkins,maven,jest,postman\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[width=\"60\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/98bb4c968619c76c911a82d9e859eb0aadfe21aaf7afa171bd3a4bcf1855c969/68747470733a2f2f63646e2e6a7364656c6976722e6e65742f67682f64657669636f6e732f64657669636f6e406c61746573742f69636f6e732f706c61797772696768742f706c61797772696768742d6f726967696e616c2e737667\" width=\"60\" height=\"55\" data-canonical-src=\"https://cdn.jsdelivr.net/gh/devicons/devicon@latest/icons/playwright/playwright-original.svg\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(13) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/ff2d1a3dd8a88320a0cd9acf1964a34394df6b6dd5bcd5498dd26778987c2680/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d617a7572652c6177732c6b756265726e657465732c646f636b65722c6769742c76657263656c\" data-canonical-src=\"https://skillicons.dev/icons?i=azure,aws,kubernetes,docker,git,vercel\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(15) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/0b881f1fe1f05f6fbad999b166f763d667f45a184156ad7b8eb1e0801991826e/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d6a6176612c6a732c74732c68746d6c\" data-canonical-src=\"https://skillicons.dev/icons?i=java,js,ts,html\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(17) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/156abd975764910a83e0c27d9fd0975c817d234ed012d959b991460fb037919b/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d6e6f74696f6e2c7375626c696d652c706f7765727368656c6c\" data-canonical-src=\"https://skillicons.dev/icons?i=notion,sublime,powershell\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(19) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/2c106fdcc529a2b0ca66d9a058b4fe55922fc26c00ad5b1b4cd5954b1bbb2df9/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d6d7973716c2c706f737467726573\" data-canonical-src=\"https://skillicons.dev/icons?i=mysql,postgres\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(21) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/0bc26df55fc8f17ece976658f58ddd7b0b71abf3e61ac0aedaa77c8464b54a23/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d77696e646f77732c7562756e7475\" data-canonical-src=\"https://skillicons.dev/icons?i=windows,ubuntu\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(23) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"] > img"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img src=\"https://camo.githubusercontent.com/f1daebeac05c35a4e54607759a19163fafe1ee0735f7e5a9ff99cd6c1973ee2a/68747470733a2f2f736b696c6c69636f6e732e6465762f69636f6e733f693d696465612c7673636f64652c637572736f72\" data-canonical-src=\"https://skillicons.dev/icons?i=idea,vscode,cursor\" style=\"max-width: 100%;\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[align=\"right\"][height=\"360\"][data-target=\"animated-image.originalImage\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img align=\"right\" src=\"https://camo.githubusercontent.com/1158e9f8063a9214cf9ecd4dd5a4cf9cc410349700f61344c5fa5ad095382cff/68747470733a2f2f692e67697068792e636f6d2f6d656469612f76312e59326c6b505463354d4749334e6a4578636d39786147566965575a686132527162584e6b4f4451795a5735326547743261546476616d747a6454497761475677595463324e795a6c634431324d563970626e526c636d35686246396e61575a66596e6c666157516d593351395a772f5a394278416f4362654a4b474b626a7775442f67697068792e676966\" height=\"360\" data-canonical-src=\"https://i.giphy.com/media/v1.Y2lkPTc5MGI3NjExcm9xaGVieWZha2RqbXNkODQyZW52eGt2aTdvamtzdTIwaGVwYTc2NyZlcD12MV9pbnRlcm5hbF9naWZfYnlfaWQmY3Q9Zw/Z9BxAoCbeJKGKbjwuD/giphy.gif\" style=\"max-width: 100%; display: inline-block;\" data-target=\"animated-image.originalImage\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p:nth-child(1) > animated-image > a[rel=\"noopener noreferrer nofollow\"][data-target=\"animated-image.originalLink\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://camo.githubusercontent.com/46e97275fd2db41b7f670c8d26d7e66e3b077bdbda626c0da7900681818312e3/68747470733a2f2f6d65646961312e74656e6f722e636f6d2f6d2f6d4e5242416c764745563441414141642f6e616e616d692d6a756a757473752d6b616973656e2e676966\" data-target=\"animated-image.originalLink\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p:nth-child(6) > animated-image > a[rel=\"noopener noreferrer nofollow\"][data-target=\"animated-image.originalLink\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://user-images.githubusercontent.com/74038190/212748830-4c709398-a386-4761-84d7-9e10b98fbe6e.gif\" data-target=\"animated-image.originalLink\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"devicon.dev\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://devicon.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(13) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(15) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(17) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(19) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(21) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p[align=\"left\"]:nth-child(23) > a[href$=\"skillicons.dev\"][rel=\"nofollow\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://skillicons.dev\" rel=\"nofollow\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "p:nth-child(25) > animated-image > a[rel=\"noopener noreferrer nofollow\"][data-target=\"animated-image.originalLink\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://camo.githubusercontent.com/1158e9f8063a9214cf9ecd4dd5a4cf9cc410349700f61344c5fa5ad095382cff/68747470733a2f2f692e67697068792e636f6d2f6d656469612f76312e59326c6b505463354d4749334e6a4578636d39786147566965575a686132527162584e6b4f4451795a5735326547743261546476616d747a6454497761475677595463324e795a6c634431324d563970626e526c636d35686246396e61575a66596e6c666157516d593351395a772f5a394278416f4362654a4b474b626a7775442f67697068792e676966\" data-target=\"animated-image.originalLink\">",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:11:27.077Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://github.com/velespitt",
        "axeVersion": "4.10.2",
        "testPageTitle": "velespitt (Yusuf)",
        "screenshotURL": null
      }
    ]
  },
  {
    "url": "https://www.linkedin.com/in/velespit/?locale=tr_TR",
    "extensionVersion": "4.97.4",
    "axeVersion": "4.10.2",
    "standard": "WCAG 2.1 AA",
    "testingStartDate": "2025-01-21T19:14:08.623Z",
    "testingEndDate": "2025-01-21T19:14:08.623Z",
    "bestPracticesEnabled": true,
    "experimentalEnabled": false,
    "issueSummary": {
      "critical": 0,
      "serious": 1,
      "moderate": 1,
      "minor": 0,
      "bestPractices": 1,
      "needsReview": 0
    },
    "remainingTestingSummary": {
      "run": false
    },
    "igtSummary": [],
    "failedRules": [
      {
        "name": "aria-hidden-focus",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "landmark-unique",
        "count": 1,
        "mode": "automated"
      }
    ],
    "needsReview": [],
    "source": {
      "productName": "axe-devtools-html",
      "productVersion": "4.97.4",
      "productComponentName": "extension-chrome"
    },
    "testDetails": {
      "testId": "",
      "axeVersion": "4.10.2",
      "engine": "axe-core",
      "standard": "WCAG 2.1 AA",
      "startDate": "2025-01-21T19:14:08.623Z",
      "endDate": "2025-01-21T19:14:08.623Z",
      "bestPracticesEnabled": true,
      "experimentalEnabled": false
    },
    "allIssues": [
      {
        "issueId": null,
        "ruleId": "aria-hidden-focus",
        "description": "Ensure aria-hidden elements are not focusable nor contain focusable elements",
        "help": "ARIA hidden element must not be focusable or contain focusable elements",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/aria-hidden-focus?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "main > .pv-profile-card.mt2[data-view-name=\"profile-card\"]:nth-child(6) > .iRQlucHUKclOVnnLzGCMMOriIYNHADAA > .pvs-header__top-container--no-stack > .pvs-header__left-container--stack > .QvYTNNlszJhnEXEKkmnBOtkhIHmILXpwOMOo > .jAnIheeFaGXOlMrxABfUZDUcGvnKmCPiY.pvs-header__optional-link > span[aria-hidden=\"true\"]"
        ],
        "summary": "Fix all of the following:\\n  Focusable content should have tabindex=\"-1\" or be removed from the DOM",
        "source": "<span aria-hidden=\"true\"><a class=\"UCscCatRDSWOVGPsBHtBFxutMeBcJczyetPkw \" target=\"_self\" href=\"https://www.linkedin.com/feed/followers/\" data-test-app-aware-link=\"\"><strong><!---->1 takipçi<!----></strong></a></span>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag412",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.4.1.2"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:14:08.623Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://www.linkedin.com/in/velespit/?locale=tr_TR",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık | LinkedIn",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "landmark-unique",
        "description": "Ensure landmarks are unique",
        "help": "Landmarks should have a unique role or role/label/title (i.e. accessible name) combination",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/landmark-unique?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".scaffold-layout__aside"
        ],
        "summary": "Fix any of the following:\\n  The landmark must have a unique aria-label, aria-labelledby, or title to make landmarks distinguishable",
        "source": "<aside class=\"scaffold-layout__aside\\n    \\n    \">",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-21T19:14:08.623Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://www.linkedin.com/in/velespit/?locale=tr_TR",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yusuf Aşık | LinkedIn",
        "screenshotURL": null
      }
    ]
  },
  {
    "url": "https://yagizdokumaci.com/",
    "extensionVersion": "4.97.4",
    "axeVersion": "4.10.2",
    "standard": "WCAG 2.1 AA",
    "testingStartDate": "2025-01-22T14:32:54.210Z",
    "testingEndDate": "2025-01-22T14:32:54.210Z",
    "bestPracticesEnabled": true,
    "experimentalEnabled": false,
    "issueSummary": {
      "critical": 5,
      "serious": 14,
      "moderate": 3,
      "minor": 0,
      "bestPractices": 3,
      "needsReview": 0
    },
    "remainingTestingSummary": {
      "run": false
    },
    "igtSummary": [],
    "failedRules": [
      {
        "name": "color-contrast",
        "count": 13,
        "mode": "automated"
      },
      {
        "name": "image-alt",
        "count": 5,
        "mode": "automated"
      },
      {
        "name": "link-name",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "landmark-one-main",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "page-has-heading-one",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "region",
        "count": 1,
        "mode": "automated"
      }
    ],
    "needsReview": [],
    "source": {
      "productName": "axe-devtools-html",
      "productVersion": "4.97.4",
      "productComponentName": "extension-chrome"
    },
    "testDetails": {
      "testId": "",
      "axeVersion": "4.10.2",
      "engine": "axe-core",
      "standard": "WCAG 2.1 AA",
      "startDate": "2025-01-22T14:32:54.210Z",
      "endDate": "2025-01-22T14:32:54.210Z",
      "bestPracticesEnabled": true,
      "experimentalEnabled": false
    },
    "allIssues": [
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#about\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.33 (foreground color: #8f8c8c, background color: #ffffff, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"#about\" class=\"nav-link\">About</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#projects\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.33 (foreground color: #8f8c8c, background color: #ffffff, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"#projects\" class=\"nav-link\">Projects</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#feedback\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.33 (foreground color: #8f8c8c, background color: #ffffff, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"#feedback\" class=\"nav-link\">Feedback.1</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".hsText"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 4.14 (foreground color: #cd05ff, background color: #ffffff, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<span class=\"hsText\"> Hi, my name is </span>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".hsParagh"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 2.51 (foreground color: #a3a3a5, background color: #ffffff, font size: 10.5pt (14px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<p class=\"hsParagh\">I'm an enthusiastic Flutter &amp; iOS Developer and researcher. Also I write Turkish articles about motivation, foods and software.</p>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "#projects > .showAllBtn[rel=\"noopener noreferrer\"][target=\"_blank\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 9.0pt (12px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://github.com/yagizdo?tab=repositories\" rel=\"noopener noreferrer\" target=\"_blank\" class=\"showAllBtn\">See All</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-4.col-12:nth-child(1) > .card > .card-body > .btn.btn-primary[variant=\"primary\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://yagizdo.medium.com/100daysofcode-challenge-ser%C3%BCveni-3c6a0323cc6f\" class=\"btn btn-primary\" variant=\"primary\" target=\"_blank\" rel=\"noopener noreferrer\">Devamı</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-4.col-12:nth-child(2) > .card > .card-body > .btn.btn-primary[variant=\"primary\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://yagizdo.medium.com/githubta-fork-edilen-proje-nas%C4%B1l-g%C3%BCncellenir-2e49b9132445\" class=\"btn btn-primary\" variant=\"primary\" target=\"_blank\" rel=\"noopener noreferrer\">Devamı</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-4.col-12:nth-child(3) > .card > .card-body > .btn.btn-primary[variant=\"primary\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://yagizdo.medium.com/bak%C4%B1rk%C3%B6y%C3%BCn-en-iyi-5-pizzac%C4%B1s%C4%B1-4073b6a1213f\" class=\"btn btn-primary\" variant=\"primary\" target=\"_blank\" rel=\"noopener noreferrer\">Devamı</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-4.col-12:nth-child(4) > .card > .card-body > .btn.btn-primary[variant=\"primary\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://yagizdo.medium.com/logitech-destek-maceram-563a100ecad5\" class=\"btn btn-primary\" variant=\"primary\" target=\"_blank\" rel=\"noopener noreferrer\">Devamı</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-4.col-12:nth-child(5) > .card > .card-body > .btn.btn-primary[variant=\"primary\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://yagizdo.medium.com/swift-storyboard-sayfalar-aras%C4%B1-ge%C3%A7i%C5%9F-ve-veri-transferi-d2f73c95a86a\" class=\"btn btn-primary\" variant=\"primary\" target=\"_blank\" rel=\"noopener noreferrer\">Devamı</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"blog.yagizdokumaci.com\"]"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.51 (foreground color: #cd05ff, background color: #f9e6fe, font size: 9.0pt (12px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"https://blog.yagizdokumaci.com\" rel=\"noopener noreferrer\" target=\"_blank\" class=\"showAllBtn\">See All</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".contactBtn"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.88 (foreground color: #c202f2, background color: #fae6ff, font size: 9.0pt (12px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<a href=\"mailto:dokumaciyagiz@gmail.com\" class=\"contactBtn\">Get In Touch</a>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[src$=\"motivation.jpg\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img class=\"card-img-top\" src=\"/img/motivation.jpg\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[src$=\"giithb.jpg\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img class=\"card-img-top\" src=\"/img/giithb.jpg\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[src$=\"pizza.jpeg\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img class=\"card-img-top\" src=\"/img/pizza.jpeg\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[src$=\"logitech.webp\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img class=\"card-img-top\" src=\"/img/logitech.webp\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "image-alt",
        "description": "Ensure <img> elements have alternative text or a role of none or presentation",
        "help": "Images must have alternative text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/image-alt?application=AxeChrome",
        "impact": "critical",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "img[src$=\"flutter_page_img.webp\"]"
        ],
        "summary": "Fix any of the following:\\n  Element does not have an alt attribute\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute\\n  Element's default semantics were not overridden with role=\"none\" or role=\"presentation\"",
        "source": "<img class=\"card-img-top\" src=\"/img/flutter_page_img.webp\">",
        "tags": [
          "cat.text-alternatives",
          "wcag2a",
          "wcag111",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT7.a",
          "TT7.b",
          "EN-301-549",
          "EN-9.1.1.1",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".navbar-brand"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"/\" class=\"navbar-brand\"><span class=\"yLogo\"></span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "landmark-one-main",
        "description": "Ensure the document has a main landmark",
        "help": "Document should have one main landmark",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/landmark-one-main?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "html"
        ],
        "summary": "Fix all of the following:\\n  Document does not have a main landmark",
        "source": "<html lang=\"en\">",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "page-has-heading-one",
        "description": "Ensure that the page, or at least one of its frames contains a level-one heading",
        "help": "Page should contain a level-one heading",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/page-has-heading-one?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "html"
        ],
        "summary": "Fix all of the following:\\n  Page must have a level-one heading",
        "source": "<html lang=\"en\">",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      },
      {
        "issueId": null,
        "ruleId": "region",
        "description": "Ensure all page content is contained by landmarks",
        "help": "All page content should be contained by landmarks",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/region?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "section"
        ],
        "summary": "Fix any of the following:\\n  Some page content is not contained by landmarks",
        "source": "<section>",
        "tags": [
          "cat.keyboard",
          "best-practice"
        ],
        "igt": "",
        "shareURL": null,
        "createdAt": "2025-01-22T14:32:54.210Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "integrationUrl": null,
        "testUrl": "https://yagizdokumaci.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "Yılmaz Yağız Dokumacı | Mobile Developer",
        "screenshotURL": null
      }
    ]
  },
  {
    "url": "https://yusufasik.com/",
    "extensionVersion": "4.97.4",
    "axeVersion": "4.10.2",
    "standard": "WCAG 2.1 AA",
    "testingStartDate": "2025-01-21T14:37:14.916Z",
    "testingEndDate": "2025-01-21T14:37:15.453Z",
    "bestPracticesEnabled": true,
    "experimentalEnabled": false,
    "issueSummary": {
      "critical": 0,
      "serious": 21,
      "moderate": 4,
      "minor": 0,
      "bestPractices": 4,
      "needsReview": 0
    },
    "remainingTestingSummary": {
      "run": false
    },
    "igtSummary": [],
    "failedRules": [
      {
        "name": "color-contrast",
        "count": 3,
        "mode": "automated"
      },
      {
        "name": "link-name",
        "count": 17,
        "mode": "automated"
      },
      {
        "name": "list",
        "count": 1,
        "mode": "automated"
      },
      {
        "name": "heading-order",
        "count": 3,
        "mode": "automated"
      },
      {
        "name": "page-has-heading-one",
        "count": 1,
        "mode": "automated"
      }
    ],
    "needsReview": [],
    "source": {
      "productName": "axe-devtools-html",
      "productVersion": "4.97.4",
      "productComponentName": "extension-chrome"
    },
    "testDetails": {
      "testId": "d6b21ec9-0a03-4949-9f06-b529b23eb685",
      "axeVersion": "4.10.2",
      "engine": "axe-core",
      "standard": "WCAG 2.1 AA",
      "startDate": "2025-01-21T14:37:14.916Z",
      "endDate": "2025-01-21T14:37:15.453Z",
      "bestPracticesEnabled": true,
      "experimentalEnabled": false
    },
    "allIssues": [
      {
        "issueId": "a423b249-f55e-46be-ba3f-c743880880f3",
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".flex-column.align-items-center.d-flex:nth-child(1) > .stats-item > p"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.04 (foreground color: #939494, background color: #ffffff, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<p>And More Tools</p>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "0b46995f-292c-463b-b9c8-a886d54344c6",
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".flex-column.align-items-center.d-flex:nth-child(2) > .stats-item > p"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.04 (foreground color: #939494, background color: #ffffff, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<p>Projects</p>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "3610d813-9a71-471a-bad1-33adde7ce8dc",
        "ruleId": "color-contrast",
        "description": "Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",
        "help": "Elements must meet minimum color contrast ratio thresholds",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".flex-column.align-items-center.d-flex:nth-child(3) > .stats-item > p"
        ],
        "summary": "Fix any of the following:\\n  Element has insufficient color contrast of 3.04 (foreground color: #939494, background color: #ffffff, font size: 12.0pt (16px), font weight: normal). Expected contrast ratio of 4.5:1",
        "source": "<p>~Days of Experience</p>",
        "tags": [
          "cat.color",
          "wcag2aa",
          "wcag143",
          "TTv5",
          "TT13.c",
          "EN-301-549",
          "EN-9.1.4.3",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "060f90ca-c57e-44b6-b934-915b1b3bb79b",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#hero\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#hero\" class=\"\"><i class=\"bi bi-house navicon\"></i><span>Home</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "802417a5-51ac-4813-9e86-f796003fd063",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#about\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#about\" class=\"\"><i class=\"bi bi-person navicon\"></i><span>About</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "e4b19d3a-90ef-4694-8fa5-8a40c5fd7bbe",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#resume\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#resume\" class=\"\"><i class=\"bi bi-file-earmark-text navicon\"></i><span>Resume</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "6049456a-8163-450f-8be3-56cc463f1833",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#portfolio\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#portfolio\" class=\"\"><i class=\"bi bi-code-slash navicon\"></i><span>Tools</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "ddd0175c-61c5-4410-ac77-fb7ba088aa2d",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#certificates\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#certificates\" class=\"\"><i class=\"bi bi-award navicon\"></i><span>Certificates</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "e8b22bdc-6a98-4ddc-8deb-627a6d05b47e",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#projects\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#projects\" class=\"\"><i class=\"bi bi-folder-symlink navicon\"></i><span>Projects</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "7d9a1bb9-aa04-4e54-8253-3621429c7ee8",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"#contact\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#contact\" class=\"active\"><i class=\"bi bi-envelope navicon\"></i><span>Contact</span></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "50095187-fc21-493e-b93f-3e64ffbae9fd",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-9 > .social-links > a[href$=\"velespitt\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://github.com/velespitt\" target=\"_blank\"><i class=\"bi bi-github\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "5d229dc5-f156-4a0c-983c-2c65457e5b88",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-9 > .social-links > a[href$=\"cv.yusufasik.com\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://cv.yusufasik.com\" target=\"_blank\"><i class=\"bi bi-file-earmark-person\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "c8ebf5ad-6504-40ce-a81c-fcd19df5a5d9",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-9 > .social-links > a[target=\"_blank\"]:nth-child(3)"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://www.linkedin.com/in/velespit/\" target=\"_blank\"><i class=\"bi bi-linkedin\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "00d7ebbe-faf9-4133-9714-c8af2bc1b043",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href=\"mailto:contact@yusuf.asik.com\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"mailto:contact@yusuf.asik.com\">\\n                <i class=\"bi bi-envelope flex-shrink-0\"></i>\\n              </a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "f085a24e-d8f2-4cdd-ae92-f0de7b8de64b",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[href$=\"testcanor\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://x.com/testcanor\" target=\"_blank\"><i class=\"bi bi-twitter-x\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "a3de4d12-d9c7-4ce1-aa7a-d9634e60c418",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".social-links.d-flex.justify-content-center > a[target=\"_blank\"]:nth-child(2)"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://discord.com/users/139137259197825029\" target=\"_blank\"><i class=\"bi bi-discord\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "fa3294d8-ffb6-47d2-8b31-fa19acbe1074",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".social-links.d-flex.justify-content-center > a[href$=\"velespitt\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://github.com/velespitt\" target=\"_blank\"><i class=\"bi bi-github\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "63fef764-ea48-4fe7-b517-3676a89e37d4",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".social-links.d-flex.justify-content-center > a[href$=\"cv.yusufasik.com\"][target=\"_blank\"]"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://cv.yusufasik.com\" target=\"_blank\"><i class=\"bi bi-file-earmark-person\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "63a12fd9-afd9-4830-a81f-8268d8ba0b13",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "a[target=\"_blank\"]:nth-child(5)"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"https://www.linkedin.com/in/velespit/\" target=\"_blank\"><i class=\"bi bi-linkedin\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "299269d1-3af6-4196-9824-4bdbeb9c436e",
        "ruleId": "link-name",
        "description": "Ensure links have discernible text",
        "help": "Links must have discernible text",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/link-name?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "#scroll-top"
        ],
        "summary": "Fix all of the following:\\n  Element is in tab order and does not have accessible text\\n\\nFix any of the following:\\n  Element does not have text that is visible to screen readers\\n  aria-label attribute does not exist or is empty\\n  aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty\\n  Element has no title attribute",
        "source": "<a href=\"#\" id=\"scroll-top\" class=\"scroll-top d-flex align-items-center justify-content-center active\"><i class=\"bi bi-arrow-up-short\"></i></a>",
        "tags": [
          "cat.name-role-value",
          "wcag2a",
          "wcag244",
          "wcag412",
          "section508",
          "section508.22.a",
          "TTv5",
          "TT6.a",
          "EN-301-549",
          "EN-9.2.4.4",
          "EN-9.4.1.2",
          "ACT"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "7b629afb-839a-4130-8591-7a577869afa9",
        "ruleId": "list",
        "description": "Ensure that lists are structured correctly",
        "help": "<ul> and <ol> must only directly contain <li>, <script> or <template> elements",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/list?application=AxeChrome",
        "impact": "serious",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-6[data-aos-delay=\"200\"][data-aos=\"fade-up\"] > .resume-item > ul"
        ],
        "summary": "Fix all of the following:\\n  List element has direct children that are not allowed: br",
        "source": "<ul>",
        "tags": [
          "cat.structure",
          "wcag2a",
          "wcag131",
          "EN-301-549",
          "EN-9.1.3.1"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "c483918d-cbff-4302-ab00-721cbef7fb11",
        "ruleId": "heading-order",
        "description": "Ensure the order of headings is semantically correct",
        "help": "Heading levels should only increase by one",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/heading-order?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".col-lg-6:nth-child(1) > .skill:nth-child(1) > h4"
        ],
        "summary": "Fix any of the following:\\n  Heading order invalid",
        "source": "<h4><i class=\"bi bi-filetype-java\"></i>Java</h4>",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "193a2570-fcc1-4f7a-a213-340cef8aba9c",
        "ruleId": "heading-order",
        "description": "Ensure the order of headings is semantically correct",
        "help": "Heading levels should only increase by one",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/heading-order?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          ".filter-app.portfolio-item.isotope-item:nth-child(1) > .portfolio-info > h4"
        ],
        "summary": "Fix any of the following:\\n  Heading order invalid",
        "source": "<h4>Selenium</h4>",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "9b03580b-7fa2-465c-abbe-2a98a7950ebc",
        "ruleId": "heading-order",
        "description": "Ensure the order of headings is semantically correct",
        "help": "Heading levels should only increase by one",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/heading-order?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "h6"
        ],
        "summary": "Fix any of the following:\\n  Heading order invalid",
        "source": "<h6>\\n                          These are my Java tasks that i wrote for myself to improve my Java skills.\\n                        </h6>",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      },
      {
        "issueId": "2389f4d3-ff76-4e22-be84-edec198cf242",
        "ruleId": "page-has-heading-one",
        "description": "Ensure that the page, or at least one of its frames contains a level-one heading",
        "help": "Page should contain a level-one heading",
        "helpUrl": "https://dequeuniversity.com/rules/axe/4.10/page-has-heading-one?application=AxeChrome",
        "impact": "moderate",
        "needsReview": false,
        "isManual": false,
        "selector": [
          "html"
        ],
        "summary": "Fix all of the following:\\n  Page must have a level-one heading",
        "source": "<html lang=\"en\">",
        "tags": [
          "cat.semantics",
          "best-practice"
        ],
        "igt": "",
        "testName": "Yusuf Aşık - SDET",
        "shareURL": null,
        "createdAt": "2025-01-21T14:37:15.394Z",
        "isExperimental": false,
        "foundBy": "yusuf.asik123@gmail.com",
        "manifestId": null,
        "integrationUrl": null,
        "igtId": null,
        "testUrl": "https://yusufasik.com/",
        "axeVersion": "4.10.2",
        "testPageTitle": "",
        "screenshotURL": "https://axe.deque.com/api/screenshots/dae84eec-d891-45bb-ba8d-9382069fb35a"
      }
    ]
  }
];
