/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.platform.suite.engine.ClassSelectorResolver;
import org.junit.platform.suite.engine.IsSuiteClass;
import org.junit.platform.suite.engine.SuiteEngineDescriptor;
import org.junit.platform.suite.engine.SuiteTestDescriptor;

final class DiscoverySelectorResolver {
    private static final EngineDiscoveryRequestResolver<SuiteEngineDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolverWithContext(context -> new IsSuiteClass(context.getIssueReporter())).addSelectorResolver(context -> new ClassSelectorResolver(context.getClassNameFilter(), (SuiteEngineDescriptor)context.getEngineDescriptor(), context.getDiscoveryRequest().getConfigurationParameters(), context.getDiscoveryRequest().getOutputDirectoryProvider(), context.getDiscoveryRequest().getDiscoveryListener(), context.getIssueReporter())).build();

    DiscoverySelectorResolver() {
    }

    private static void discoverSuites(SuiteEngineDescriptor engineDescriptor) {
        engineDescriptor.getChildren().stream().map(SuiteTestDescriptor.class::cast).forEach(SuiteTestDescriptor::discover);
    }

    void resolveSelectors(EngineDiscoveryRequest request, SuiteEngineDescriptor engineDescriptor) {
        DiscoveryIssueReporter issueReporter = DiscoveryIssueReporter.deduplicating(DiscoveryIssueReporter.forwarding(request.getDiscoveryListener(), engineDescriptor.getUniqueId()));
        resolver.resolve(request, engineDescriptor, issueReporter);
        DiscoverySelectorResolver.discoverSuites(engineDescriptor);
        engineDescriptor.accept(TestDescriptor::prune);
    }
}

