/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.discovery;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

class LoggingLauncherDiscoveryListener
implements LauncherDiscoveryListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingLauncherDiscoveryListener.class);

    LoggingLauncherDiscoveryListener() {
    }

    @Override
    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        logger.trace(() -> "Test discovery started");
    }

    @Override
    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        logger.trace(() -> "Test discovery finished");
    }

    @Override
    public void engineDiscoveryStarted(UniqueId engineId) {
        logger.trace(() -> "Engine " + engineId + " has started discovering tests");
    }

    @Override
    public void engineDiscoveryFinished(UniqueId engineId, EngineDiscoveryResult result) {
        if (result.getStatus() == EngineDiscoveryResult.Status.FAILED) {
            Optional<Throwable> failure = result.getThrowable();
            if (failure.isPresent()) {
                logger.error(failure.get().getCause(), () -> ((Throwable)failure.get()).getMessage());
            } else {
                logger.error(() -> "Engine " + engineId + " failed to discover tests");
            }
        } else {
            logger.trace(() -> "Engine " + engineId + " has finished discovering tests");
        }
    }

    @Override
    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        switch (result.getStatus()) {
            case RESOLVED: {
                logger.debug(() -> selector + " was resolved by " + engineId);
                break;
            }
            case FAILED: {
                logger.error(result.getThrowable().orElse(null), () -> "Resolution of " + selector + " by " + engineId + " failed");
                break;
            }
            case UNRESOLVED: {
                UniqueId uniqueId;
                Consumer<Supplier> loggingConsumer = logger::debug;
                if (selector instanceof UniqueIdSelector && (uniqueId = ((UniqueIdSelector)selector).getUniqueId()).hasPrefix(engineId)) {
                    loggingConsumer = logger::warn;
                }
                loggingConsumer.accept(() -> selector + " could not be resolved by " + engineId);
            }
        }
    }

    @Override
    public void issueEncountered(UniqueId engineId, DiscoveryIssue issue) {
        logger.trace(() -> "Issue encountered during discovery by TestEngine with ID '" + engineId + "': " + issue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 1;
    }
}

