/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.LineNumberNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.cli.internal.core.internal.analysis.filter.KotlinSMAP;

final class KotlinInlineFilter
implements IFilter {
    private int firstGeneratedLineNumber = -1;

    KotlinInlineFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceDebugExtension() == null) {
            return;
        }
        if (this.firstGeneratedLineNumber == -1) {
            this.firstGeneratedLineNumber = KotlinInlineFilter.getFirstGeneratedLineNumber(context.getClassName(), context.getSourceFileName(), context.getSourceDebugExtension());
        }
        int line = 0;
        for (AbstractInsnNode i : methodNode.instructions) {
            if (15 == i.getType()) {
                line = ((LineNumberNode)i).line;
            }
            if (line < this.firstGeneratedLineNumber) continue;
            output.ignore(i, i);
        }
    }

    private static int getFirstGeneratedLineNumber(String className, String sourceFileName, String smap) {
        int min = Integer.MAX_VALUE;
        for (KotlinSMAP.Mapping mapping : new KotlinSMAP(sourceFileName, smap).mappings()) {
            if (className.equals(mapping.inputClassName()) && mapping.inputStartLine() == mapping.outputStartLine()) continue;
            min = Math.min(mapping.outputStartLine(), min);
        }
        return min;
    }
}

