/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;

@API(status=API.Status.INTERNAL, since="1.13")
public enum CustomClassLoaderCloseStrategy {
    CLOSE_AFTER_CALLING_LAUNCHER{

        @Override
        public void handle(ClassLoader customClassLoader) {
            if (customClassLoader instanceof AutoCloseable) {
                this.close((AutoCloseable)((Object)customClassLoader));
            }
        }

        private void close(AutoCloseable customClassLoader) {
            try {
                customClassLoader.close();
            }
            catch (Exception e) {
                throw new JUnitException("Failed to close custom class loader", e);
            }
        }
    }
    ,
    KEEP_OPEN{

        @Override
        public void handle(ClassLoader customClassLoader) {
        }
    };


    public abstract void handle(ClassLoader var1);
}

