package acts.act15;

public class MyArrayList {

    private char[] data = new char[10];
    private int size;

    public void add(char item) {
        if (size == data.length) {
            grow();
        } else {
            shift();
        }
        data[0] = item;
        size++;
    }

    private void grow() {
        // make the new data array 50% larger
        char[] old = data;
        int newLen = (int) (old.length * 1.5);
        data = new char[newLen];
        // copy and shift from old to new array
        for (int i = size; i > 0; i--) {
            data[i] = old[i - 1];
        }
    }

    private void shift() {
        for (int i = size; i > 0; i--) {
            data[i] = data[i - 1];
        }
    }

    public static void main(String[] args) {
        MyArrayList list = new MyArrayList();
        list.add('A');
        list.add('B');
        list.add('C');
    }

}
