"""Little Library inventories and actions.

You should not need to modify this file.
You should not submit this file as part of your homework.

Author: CS149 Faculty
Version: 09/23/2025
"""


def list_books(books):
    """Print an abbreviated list of the titles in the inventory.

    If there are more than 200 titles, print only the first 50 titles.

    Args:
        books (list): a list of book titles (strings)

    Returns:
        printed (list): a list of titles printed to the screen
    """
    printed = books
    if len(books) > 200:
        printed = books[:50]
    print("Books in inventory:\n", printed)
    return printed


def search_books(books, title_substring):
    """Search the inventory to see how many copies match.

    Return a list of titles that contain the given substring.

    Args:
        books (list): a list of book titles (strings)
        title_substring (str): a substring to search for in the titles

    Returns:
        matches (list): a list of titles that contain the given substring
    """
    matches = [b for b in books if title_substring.lower() in b.lower()]
    return matches


def remove_book(books, title):
    """Remove a book from the inventory.

    The patron wishes to take a book from the library.

    Args:
        books (list): a list of book titles (strings)
        title (str): the title of the book to remove

    Returns:
        success (bool): True if the book was removed, False otherwise
    """
    if title in books:
        books.remove(title)
        return True
    return False


def add_book(books, title):
    """Add a book to the inventory.

    The patron wishes to donate a book to the library.

    Args:
        books (list): a list of book titles (strings)
        title (str): the title of the book to add

    Returns:
        count (int): the number of titles now in the inventory
    """
    books.append(title)
    return len(books)


# provide 3 different sized libraries for testing
inventory = {
    "small": [
        "Project Hail Mary",
        "The Hobbit",
        "Sherlock Holmes",
        "The Hobbit",
        "Dune",
        "Walkaway",
    ],
    "medium": [
        "Java in Two Semesters",
        "The Design of Everyday Things",
        "The Wes Anderson Collection",
        "The Year of the Perfect Christmas Tree: An Appalachian Story",
        "The Giver (Newbery Medal Book)",
        "Keys to Good Cooking: A Guide to Making the Best of Foods and Recipes",
        "The BFG",
        "Ethical Ambition: Living a Life of Meaning and Worth",
        "The Future of the Public University in America: Beyond the Crossroads",
        "Angels in America: A Gay Fantasia on National Themes: Part One: Millennium Approaches Part Two: Perestroika",
        "The Wal-Mart Effect: How the World's Most Powerful Company Really Works--and HowIt's Transforming the American Economy",
        "S.",
        "Love",
        "American Education: A History",
        "Our Underachieving Colleges: A Candid Look at How Much Students Learn and Why They Should Be Learning More",
        "Feminism Is for Everybody: Passionate Politics",
        "M. C. Escher",
        "Ubik",
        "The Life-Changing Magic of Tidying Up: The Japanese Art of Decluttering and Organizing",
        "Xenocide (Ender, Book 3)",
        "Intuition Pumps And Other Tools for Thinking",
        "Academic Duty",
        "The Swerve: How the World Became Modern",
        "The Struggle for the American Curriculum, 1893-1958",
        "Approaching the Qur'an: The Early Revelations",
        "Alone Together",
        "Aramis, or the Love of Technology",
        "Technology and the Lifeworld: From Garden to Earth (Indiana Series in the Philosophy of Technology)",
        "The Social Life of Information",
        "The Mythical Man-Month: Essays on Software Engineering, Anniversary Edition (2nd Edition)",
        "Cheating: Gaining Advantage in Videogames",
        "From Counterculture to Cyberculture: Stewart Brand, the Whole Earth Network, and the Rise of Digital Utopianism",
        "Discovering Statistics Using R",
        "Experimental Design and Statistics for Psychology",
        "A Qualitative Stance",
        "Doing Cultural Studies: The Story of the Sony Walkman (Culture, Media and Identities series)",
        "Emotional Design: Why We Love (or Hate) Everyday Things",
        "Learner-Centered Teaching: Five Key Changes to Practice",
        "Research Methods in Human Computer Interaction",
        "Interaction Design: Beyond Human-Computer Interaction",
        "Engineering Psychology and Human Performance (3rd Edition)",
        "HCI Models, Theories, and Frameworks: Toward a Multidisciplinary Science (Interactive Technologies)",
        "HCI Remixed: Essays on Works That Have Influenced the HCI Community HCI Remixed",
        "Thoughtful Interaction Design: A Design Perspective on Information Technology",
        "Where the Action Is: The Foundations of Embodied Interaction (Bradford Books)",
        "Universal Principles of Design, Revised and Updated: 125 Ways to Enhance Usability, Influence Perception, Increase Appeal, Make Better Design Decisions, and Teach through Design",
        "Usability Engineering",
        "Designing Interactions",
        "Interaction Design: Beyond Human-Computer Interaction",
        "The UX Book: Process and Guidelines for Ensuring a Quality User Experience",
        "Connecting Families: The Impact of New Communication Technologies on Domestic Life (Computer Supported Cooperative Work)",
        "Cracking the Coding Interview, 6th Edition: 189 Programming Questions and Solutions",
        "About Face: The Essentials of Interaction Design",
        "Understanding Comics",
        "Emerging Research, Practice, and Policy on Computational Thinking",
        "Sex in the Heartland",
        "Great Mambo Chicken And The Transhuman Condition: Science Slightly Over The Edge",
        "White Women, Black Men: Illicit Sex in the Nineteenth-Century South",
        "Guns, Germs, and Steel: The Fates of Human Societies",
        "Pedagogy of the Oppressed, 30th Anniversary Edition",
        "The Tao of Pooh",
        "Zen and the Art of Motorcycle Maintenance",
        "Gay New York: Gender, Urban Culture, and the Making of the Gay Male World, 1890-1940",
        "Master Harold . . . And The Boys (Penguin Plays)",
        "Let the Dead Bury Their Dead (Harvest American Writing Series)",
        "Politics of Reality: Essays in Feminist Theory (Crossing Press Feminist)",
        "The Ways of White Folks: Stories (Vintage Classics)",
        "Why Are All The Black Kids Sitting Together in the Cafeteria?",
        "The Universal Sense: How Hearing Shapes the Mind",
        "Tales of the City (Tales of the City Series, V. 1)",
        "The House Of The Spirits",
        "Pedro Paramo",
        "The UX Book: Agile UX Design for a Quality User Experience",
        "The Poisonwood Bible (Oprah's Book Club)",
        "C*nt: A Declaration of Independence Expanded and Updated Second Edition",
        "Autobiography of a Blue-Eyed Devil: My Life and Times in a Racist, Imperialist Society",
        "50 Key Concepts in Gender Studies (SAGE Key Concepts series)",
        "Fried Green Tomatoes at the Whistle Stop Cafe",
        "Gogol: Plays and Selected Writings (European Drama Classics)",
        "The Boy Scout Handbook",
        "Order of the Arrow Handbook",
        "Cooked: A Natural History of Transformation",
        "Memoirs of a Geisha: A Novel",
        "Ham Radio License Manual with CD (Arrl Ham Radio License Manual)",
        "So Long a Letter (African Writers)",
        "A Door Into Ocean (Elysium Cycle)",
        "A War of Gifts: An Ender Story (Ender Wiggin Saga)",
        "Children of the Mind (Ender, Book 4)",
        "So Long, and Thanks For All The Fish",
        "First Meetings in Ender's Universe",
        "The Restaurant at the End of the Universe",
        "The Andromeda Strain",
        "Ender in Exile",
        "Shadow Puppets (Ender, Book 7)",
        "Hyperbole and a Half: Unfortunate Situations, Flawed Coping Mechanisms, Mayhem, and Other Things That Happened",
        "Reclaiming Conversation: The Power of Talk in a Digital Age",
        "Going Solo: The Extraordinary Rise and Surprising Appeal of Living Alone",
        "Bowling Alone: The Collapse and Revival of American Community",
        "Generation Me: Why Today's Young Americans Are More Confident, Assertive, Entitled--and More Miserable Than Ever Before",
        "Freakonomics: A Rogue Economist Explores the Hidden Side of Everything (P.S.)",
        "Intertwingled: Information Changes Everything",
        "COOP 2014 - Proceedings of the 11th International Conference on the Design of Cooperative Systems, 27-30 May 2014, Nice (France)",
        "Minds Online: Teaching Effectively with Technology",
        "Engineering Software as a Service: An Agile Approach Using Cloud Computing",
        "Programming Language Pragmatics, Third Edition",
        "Introduction to Algorithms, Second Edition",
        "Starting Out with Java: From Control Structures through Objects (7th Edition) (What's New in Computer Science)",
        "Web GIS: Principles and Applications",
        "Lauren Ipsum",
        "System Forensics, Investigation and Response",
        "Computer Security: Protecting Digital Resources",
        "Elementary Information Security",
        "Addison-Wesley's Review for the AP Computer Science Exam in Java",
        "Computer Science",
        "Web Based Application Development",
        "Starting Out with Java: From Control Structures through Objects (6th Edition)",
        "Computer Science: An Overview (12th Edition)",
        "Programming the World Wide Web",
        "Fundamentals of Web Development",
        "Node. js, MongoDB and Angular Web Development",
        "Why Are All the Black Kids Sitting Together in the Cafeteria?: And Other Conversations About Race",
        "Racism Without Racists",
        "The Privileged Poor",
        "Nice White Ladies",
        "Sister Outsider: Essays and Speeches (Crossing Press Feminist Series)",
        "We Want to Do More Than Survive",
        "Teaching to Transgress: Education as the Practice of Freedom",
        "Thick",
        "Eloquent Rage",
        "The Immortal Life of Henrietta Lacks",
        "Design Justice",
        "Race after Technology",
        "Algorithms of Oppression",
        "Dark Matters: On the Surveillance of Blackness",
        "Automating Inequality",
        "Technically Wrong: Sexist Apps, Biased Algorithms, and Other Threats of Toxic Tech",
        "Weapons of Math Destruction: How Big Data Increases Inequality and Threatens Democracy",
        "Radical Equations: Civil Rights from Mississippi to the Algebra Project",
        "Invisible Women",
        "Walkaway",
    ],
    "large": [
        "Aesop's Fables",
        "Metamorphoses",
        "Chaireas and Kallirhoe - Chariton",
        "Aithiopika",
        "The Thousand and One Nights",
        "The Tale of the Bamboo Cutter",
        "The Tale of Genji",
        "Romance of the Three Kingdoms",
        "Nai'an, Shi -The Water Margin",
        "The Golden Ass",
        "Tirant lo Blanc",
        "La Celestina",
        "Amadis of Gaul",
        "The Life of Lazarillo de Tormes",
        "Gargantua and Pantagruel",
        "The Lusiad",
        "Ch'eng-en, Wu - Monkey - Journey to the West",
        "Euphues : The Anatomy of Wit",
        "The Unfortunate Traveller",
        "Thomas of Reading",
        "Don Quixote",
        "The Travels of Persiles and Sigismunda",
        "The Conquest of New Spain",
        "The Adventurous Simplicissimus",
        "The Pilgrim's Progress - John Bunyan",
        "The Princess of Cleves",
        "Oroonoko",
        "A Tale of a Tub",
        "Robinson Crusoe",
        "Love in Excess",
        "Moll Flanders",
        "Roxana",
        "Gulliver's Travels",
        "A Modest Proposal",
        "Joseph Andrews",
        "Memoirs of Martinus Scriblerus",
        "Pamela",
        "Clarissa",
        "Roderick Random",
        "Tom Jones",
        "Fanny Hill",
        "Peregrine Pickle",
        "Amelia",
        "The Female Quixote",
        "Candide",
        "Rasselas",
        "Rousseau, Jean-Jacques - Julie; or, the New Eloise",
        "Rousseau, Jean-Jacques - Emile; or, On Education",
        "The Castle of Otranto",
        "The Vicar of Wakefield",
        "Tristram Shandy",
        "A Sentimental Journey",
        "The Man of Feeling",
        "Humphry Clinker",
        "The Sorrows of Young Werther",
        "Evelina",
        "Rousseau, Jean-Jacques - Reveries of a Solitary Walker",
        "Dangerous Liaisons",
        "Rousseau, Jean-Jacques - Confessions",
        "Cecilia",
        "The 120 Days of Sodom",
        "Anton Reiser",
        "Vathek",
        "Justine",
        "A Dream of Red Mansions",
        "The Adventures of Caleb Williams",
        "The Interesting Narrative",
        "The Mysteries of Udolpho",
        "Wilhelm Meister's Apprenticeship",
        "The Monk",
        "Camilla",
        "Jacques the Fatalist",
        "The Nun",
        "Hyperion",
        "Castle Rackrent",
        "Henry of Ofterdingen",
        "Rameau's Nephew",
        "Elective Affinities",
        "The Absentee",
        "Michael Kohlhaas",
        "Sense and Sensibility",
        "Pride and Prejudice",
        "Mansfield Park",
        "Emma",
        "Rob Roy",
        "Ormond",
        "Persuasion",
        "Northanger Abbey",
        "Frankenstein",
        "Ivanhoe",
        "The Monastery",
        "Melmoth the Wanderer",
        "The Albigenses",
        "The Life and Opinions of the Tomcat Murr",
        "The Private Memoirs and Confessions of a Justified Sinner",
        "The Life of a Good-for-Nothing",
        "Last of the Mohicans",
        "The Betrothed",
        "The Red and the Black",
        "The Hunchback of Notre Dame",
        "Eugene Onegin",
        "Eugenie Grandet",
        "Le Pere Goriot",
        "The Nose",
        "Oliver Twist",
        "The Life and Adventures of Nicholas Nickleby",
        "The Lion of Flanders",
        "The Charterhouse of Parma",
        "The Fall of the House of Usher",
        "Camera Obscura",
        "A Hero of Our Time",
        "Dead Souls",
        "A Christmas Carol",
        "Lost Illusions",
        "The Pit and the Pendulum",
        "Martin Chuzzlewit",
        "The Purloined Letter",
        "The Three Musketeers",
        "Le Reine Margot",
        "Facundo",
        "The Devil's Pool",
        "The Count of Monte-Cristo",
        "Jane Eyre",
        "Vanity Fair",
        "Agnes Grey",
        "Wuthering Heights",
        "The Tenant of Wildfell Hall",
        "Mary Barton",
        "Shirley",
        "David Copperfield",
        "The Scarlet Letter",
        "Moby Dick",
        "The House of the Seven Gables",
        "The Blithedale Romance",
        "Uncle Tom's Cabin",
        "Cranford",
        "Villette",
        "Bleak House",
        "Walden",
        "Hard Times",
        "Green Henry",
        "North and South",
        "Madame Bovary",
        "Indian Summer",
        "Adam Bede",
        "Oblomov",
        "A Tale of Two Cities",
        "The Woman in White",
        "The Mill on the Floss",
        "Castle Richmond",
        "On the Eve",
        "Max Havelaar",
        "The Marble Faun",
        "Great Expectations",
        "Silas Marner",
        "Fathers and Sons",
        "Les Miserables",
        "The Water-Babies",
        "Notes from the Underground",
        "Uncle Silas",
        "Our Mutual Friend",
        "Alice's Adventures in Wonderland",
        "Journey to the Centre of the Earth",
        "Crime and Punishment",
        "The Last Chronicle of Barset",
        "Therese Raquin",
        "The Moonstone",
        "Little Women",
        "The Idiot",
        "Maldoror",
        "Phineas Finn",
        "Sentimental Education",
        "War and Peace",
        "He Knew He Was Right",
        "King Lear of the Steppes",
        "Through the Looking Glass",
        "Middlemarch",
        "Spring Torrents",
        "Erewhon",
        "Dostoevsky, Fyodor -The Devils",
        "In a Glass Darkly",
        "Around the World in Eighty Days",
        "The Enchanted Wanderer",
        "Far from the Madding Crowd",
        "The Temptation of Saint Anthony",
        "The Hand of Ethelberta",
        "Daniel Deronda",
        "Virgin Soil",
        "Pepita Jimenez",
        "The Crime of Father Amaro",
        "Drunkard",
        "Anna Karenina",
        "Return of the Native",
        "Martin Fierro",
        "The Red Room",
        "The Brothers Karamazov",
        "Ben-Hur",
        "Nana",
        "The Portrait of a Lady",
        "The House by the Medlar Tree",
        "The Posthumous Memoirs of Bras Cubas",
        "Bouvard and Pecuchet",
        "Treasure Island",
        "A Woman's Life",
        "The Death of Ivan Ilyich",
        "Huysmans, Joris-Karl - Against the Grain",
        "The Regent's Wife",
        "Bel-Ami",
        "Marius the Epicurean",
        "The Adventures of Huckleberry Finn",
        "Germinal",
        "King Solomon's Mines",
        "Kidnapped",
        "The Mayor of Casterbridge",
        "The Quest",
        "The Strange Case of Dr. Jekyll and Mr Hyde",
        "She",
        "The Woodlanders",
        "The Manors of Ulloa",
        "The People of Hemso",
        "Fortunata y Jacinta",
        "Pierre and Jean",
        "The Master of Ballantrae",
        "Under the Yoke",
        "D'Annunzio, Gabriele The Child of Pleasure",
        "Eline Vere",
        "Hunger",
        "By the Open Sea",
        "La Bete Humaine",
        "Thais",
        "The Kreutzer Sonata",
        "The Picture of Dorian Gray",
        "Huysmans, Joris-Karl - Down There",
        "Tess of the D'Urbervilles",
        "Gosta Berling's Saga",
        "New Grub Street",
        "News from Nowhere",
        "The Adventures of Sherlock Holmes",
        "Diary of a Nobody",
        "Born in Exile",
        "The Yellow Wallpaper",
        "The Real Charlotte",
        "The Viceroys",
        "Jude the Obscure",
        "Effi Briest",
        "The Time Machine",
        "The Island of Dr. Moreau",
        "Quo Vadis",
        "Dracula",
        "What Maisie Knew",
        "The Invisible Man",
        "Compassion",
        "Pharoah",
        "Fruits of the Earth",
        "The War of the Worlds",
        "The Turn of the Screw",
        "As a Man Grows Older",
        "Dom Casmurro",
        "The Awakening -",
        "The Stechlin",
        "Eclipse of the Crescent Moon",
        "Some Experiences of an Irish R.M.",
        "Sandokan: The Tigers of Mompracem",
        "Sister Carrie",
        "Lord Jim",
        "None but the Brave",
        "Kim",
        "Buddenbrooks",
        "The Hound of the Baskervilles",
        "Heart of Darkness",
        "The Wings of the Dove",
        "The Immoralist",
        "The Ambassadors",
        "The Golden Bowl",
        "The Riddle of the Sands",
        "The Call of the Wild",
        "Memoirs of my Nervous Illness",
        "The Way of All Flesh",
        "Hadrian the Seventh",
        "Nostromo",
        "Where Angels Fear to Tread",
        "The House of Mirth",
        "Professor Unrat",
        "Solitude",
        "Young Torless",
        "The Forsyte Saga",
        "The Jungle",
        "The Secret Agent",
        "Mother",
        "The House on the Borderland",
        "The Old Wives' Tale",
        "The Iron Heel",
        "The Inferno",
        "Tono-Bungay",
        "A Room With a View",
        "Strait is the Gate",
        "Martin Eden",
        "Three Lives",
        "The Notebooks of Malte Laurids Brigge",
        "Howards End",
        "Impressions of Africa",
        "Fantamos",
        "Ethan Frome",
        "The Charwoman's Daughter",
        "Death in Venice",
        "Sons and Lovers",
        "The Ragged Trousered Philanthropists",
        "Platero and I",
        "Tarzan of the Apes",
        "Rosshalde",
        "Locus Solus",
        "Kokoro",
        "The Thirty-Nine Steps",
        "The Rainbow",
        "Of Human Bondage",
        "The Voyage Out",
        "The Good Soldier",
        "Rashomon",
        "Under Fire",
        "A Portrait of the Artist as a Young Man",
        "Bunner Sisters",
        "The Underdogs",
        "Pallieter",
        "The Home and the World",
        "Growth of the Soil",
        "Summer",
        "The Shadow Line",
        "The Return of the Soldier",
        "Tarr",
        "Night and Day",
        "The Storm of Steel",
        "Women in Love",
        "Main Street",
        "The Age of Innocence",
        "Crome Yellow",
        "The Fox",
        "Life of Christ",
        "Ulysses",
        "Babbit",
        "Aaron's Rod",
        "The Last Days of Humanity",
        "Claudine's House",
        "Life and Death of Harriett Frean",
        "Glimpses of the Moon",
        "The Forest of the Hanged",
        "Siddhartha",
        "Jacob's Room",
        "The Enormous Room",
        "The Garden Party",
        "Kristin Lavransdatter",
        "Amok",
        "Antic Hay",
        "Cane",
        "The Devil in the Flesh",
        "Zeno's Conscience",
        "A Passage to India",
        "We",
        "The Magic Mountain",
        "The Green Hat",
        "Billy Budd, Foretopman",
        "The New World",
        "The Professor's House",
        "The Artamonov Business",
        "The Trial",
        "The Counterfeiters",
        "The Great Gatsby",
        "Mrs. Dalloway re-read",
        "Manhattan Transfer",
        "Mofolo, Thomas Chaka the Zulu",
        "The Making of Americans",
        "The Murder of Roger Ackroyd",
        "One, No One and One Hundred Thousand",
        "The Plumed Serpent",
        "Under Satan's Sun",
        "The Good Soldier Svejk",
        "Alberta and Jacob",
        "The Castle",
        "Blindness",
        "The Sun Also Rises",
        "Amerika",
        "The Case of Sergeant Grischa",
        "Tarka the Otter",
        "To The Lighthouse",
        "Remembrance of Things Past",
        "Siddhartha",
        "Nadja",
        "Quicksand",
        "Decline and Fall",
        "Quartet",
        "The Childermass",
        "Some Prefer Nettles",
        "Parade's End",
        "The Well of Loneliness",
        "Lady Chatterley's Lover",
        "Orlando",
        "Story of the Eye",
        "Retreat Without Song",
        "Les Enfants Terribles",
        "The Sound and the Fury",
        "Harriet Hume",
        "The Last September",
        "Berlin Alexanderplatz",
        "All Quiet on the Western Front",
        "The Time of Indifference",
        "Living",
        "The Red Harvest",
        "I Thought of Daisy",
        "A Farewell to Arms",
        "Passing",
        "Hebdomeros",
        "Look Homeward, Angel",
        "The Maltese Falcon",
        "Vile Bodies",
        "Her Privates We",
        "the Apes of God",
        "Cakes and Ale",
        "The Glass Key",
        "Monica",
        "Insatiability",
        "The Waves",
        "To the North",
        "The Thin Man",
        "Celine, Louis-Ferdinand - Journey to the End of the Night",
        "Sunset Song",
        "The Return of Philip Latinowicz",
        "The Radetzky March",
        "The Forbidden Realm",
        "Cold Comfort Farm",
        "Brave New World",
        "Vipers' Tangle",
        "The Man Without Qualities",
        "Cheese",
        "Man's Fate",
        "A Day Off",
        "Testament of Youth",
        "The Autobiography of Alice B. Toklas",
        "Murder Must Advertise",
        "Miss Lonelyhearts",
        "Call it Sleep",
        "The Street of Crocodiles",
        "Thank You, Jeeves",
        "Tender is the Night",
        "A Handful of Dust",
        "Tropic of Cancer",
        "The Postman Always Rings Twice",
        "Novel With Cocaine",
        "Threepenny Novel",
        "On the Heights of Despair",
        "The Bells of Basel",
        "The Nine Tailors",
        "Burmese Days",
        "England Made Me",
        "The House in Paris",
        "Auto-da-Fe",
        "They Shoot Horses, Don't They?",
        "The Last of Mr. Norris",
        "Untouchable",
        "Independent People",
        "Nightwood",
        "At the Mountains of Madness",
        "Absalom, Absalom!",
        "Wild Harbour",
        "War with the Newts",
        "Keep the Aspidistra Flying",
        "Gone with the Wind",
        "The Thinking Reed",
        "Eyeless in Gaza",
        "Summer Will Show",
        "To Have and Have Not",
        "Rickshaw Boy",
        "Out of Africa",
        "The Revenge for Love",
        "In Parenthesis",
        "Ferdydurke",
        "The Blind Owl",
        "The Hobbit",
        "The Years",
        "Their Eyes Were Watching God",
        "Of Mice and Men",
        "Murphy",
        "U.S.A.",
        "Brighton Rock",
        "Cause for Alarm",
        "Alamut",
        "Rebecca",
        "Satre, Jean-Paul - Nausea",
        "Miss Pettigrew Lives for a Day",
        "After the Death of Don Juan",
        "On the Edge of Reason",
        "The Big Sleep",
        "Goodbye to Berlin",
        "Coming Up for Air",
        "The Grapes of Wrath",
        "Party Going",
        "Good Morning, Midnight",
        "Tropic of Capricorn",
        "At Swim-Two-Birds",
        "Finnegans Wake",
        "Native Son",
        "The Tartar Steppe",
        "The Power and the Glory",
        "For Whom the Bells Toll",
        "Farewell My Lovely",
        "The Hamlet",
        "Between the Acts",
        "Hangover Square",
        "The Man Who Loved Children",
        "Broad and Alien is the World",
        "The Living and the Dead",
        "The Poor Mouth",
        "The Harvesters",
        "Conversations in Sicily",
        "The Outsider",
        "Go Down, Moses",
        "Embers",
        "Chess Story",
        "The Glass Bead Game",
        "Caught",
        "Joseph and His Brothers",
        "de Saint-Exupery, Antoine - The Little Prince",
        "Dangling Man",
        "Ficciones",
        "The Razor's Edge",
        "Transit",
        "Lindgren, Astrid",
        "Loving",
        "The Pursuit of Love",
        "Cannery Row",
        "Animal Farm",
        "The Bridge on the Drina",
        "Christ Stopped at Eboli",
        "Arcanum 17",
        "Brideshead Revisited",
        "Bosnian Chronicle",
        "The Tin Flute",
        "Andrea",
        "The Death of Virgil",
        "Titus Groan",
        "Zorba the Greek",
        "Back",
        "House in the Uplands",
        "The Path to the Nest of Spiders",
        "Under the Volcano",
        "If This Is a Man",
        "Exercises in Style",
        "The Victim",
        "The Plague",
        "Doctor Faustus",
        "Midaq Alley",
        "Froth on the Daydream",
        "Journey to the Alcarria",
        "Ashes and Diamonds",
        "Disobedience",
        "All About Hatterr",
        "Cry, The Beloved Country",
        "The Heart of the Matter",
        "In the Heart of the Seas",
        "This Way for the Gas, Ladies and Gentlemen",
        "Death Sentence",
        "Nineteen Eighty-Four",
        "The Man with the Golden Arm",
        "Kingdom of this World",
        "The Heat of the Day",
        "Love in a Cold Climate",
        "The Case of Comrade Tulayev",
        "The Garden Where the Brass Band Played",
        "I, Robot",
        "The Grass is Singing",
        "A Town Like Alice",
        "The Moon and the Bonfires",
        "Gormenghast",
        "The 13 Clocks",
        "The Third Man",
        "The Labyrinth of Solitude",
        "The Abbot C",
        "The Guiltless",
        "Barabbas",
        "The End of the Affair",
        "Molloy",
        "The Rebel",
        "The Catcher in the Rye",
        "The Opposing Shore",
        "Foundation",
        "Malone Dies",
        "Day of the Triffids",
        "Memoirs of Hadrian",
        "The Killer Inside Me",
        "The Hive",
        "Wise Blood",
        "The Old Man and the Sea",
        "Invisible Man",
        "The Judge and His Hangman",
        "Excellent Women",
        "A Thousand Cranes",
        "Go Tell It on the Mountain",
        "The Adventures of Augie March",
        "Casino Royale",
        "Junkie",
        "Lucky Jim",
        "The Lost Steps",
        "The Hothouse",
        "Watt",
        "The Unnamable",
        "The Long Goodbye",
        "The Go-Between",
        "The Dark Child",
        "A Day in Spring",
        "A Ghost at Noon",
        "The Story of O",
        "Under the Net",
        "The Lord of the Flies",
        "The Mandarins",
        "Bonjour Tristesse",
        "Death in Rome",
        "The Sound of Waves",
        "The Unknown Soldier",
        "Self Condemned",
        "I'm Not Stiller",
        "The Ragazzi",
        "The Recognitions",
        "The Burning Plain and Other Stories",
        "The Quiet American",
        "The Trusting and the Maimed",
        "A World of Love",
        "The Tree of Man",
        "The Last Temptation of Christ",
        "The Devil to Pay in the Backlands",
        "Lolita",
        "The Talented Mr. Ripley",
        "The Lord of the Rings",
        "The Lonely Londoners",
        "The Roots of Heaven",
        "The Floating Opera",
        "Seize the Day",
        "Giovanni's Room",
        "Justine",
        'The Wonderful "O"',
        "The Glass Bees",
        "Doctor Zhivago",
        "Pnin",
        "On the Road",
        "The Manila Rope",
        "The Deadbeats",
        "Homo Faber",
        "Blue of Noon",
        "The Midwich Cuckoo",
        "Voss",
        "Robbe-Grillet, John - Jealousy",
        "The Birds",
        "The Once and Future King",
        "The End of the Road",
        "The Bell",
        "Borstal Boy",
        "Mrs 'Arris Goes to Paris",
        "Gabriela, Clove and Cinnamon",
        "Saturday Night and Sunday Morning",
        "Things Fall Apart",
        "The Bitter Glass",
        "The Guide",
        "The Leopard",
        "Deep Rivers",
        "- Capote, Truman - Breakfast at Tiffany's",
        "Pluck the Bud and Destroy the Offspring",
        "Billiards at Half-Past Nine",
        "Memento Mori",
        "Henderson the Rain King",
        "Down Second Avenue",
        "Cider with Rosie",
        "The Tin Drum",
        "Naked Lunch",
        "Billy Liar",
        "Absolute Beginners",
        "Promise at Dawn",
        "Rabbit, Run",
        "To Kill a Mockingbird",
        "The Magician of Lublin",
        "Halftime",
        "The Country Girls",
        "Our Ancestors",
        "How It Is",
        "The Violent Bear it Away",
        "Bebo's Girl",
        "God's Bit of Wood",
        "The Shipyard",
        "Catch-22",
        "Solaris",
        "Cat and Mouse",
        "The Prime of Miss Jean Brodie",
        "A Severed Head",
        "Franny and Zooey",
        "No One Writes to the Colonel",
        "Faces in the Water",
        "Memoirs of a Peasant Boy",
        "Stranger in a Strange Land",
        "Labyrinths",
        "The Golden Notebook",
        "The Drowned World",
        "Time of Silence",
        "Pale Fire",
        "A Clockwork Orange",
        "One Flew Over the Cuckoo's Nest",
        "The Collector",
        "Girl with Green Eyes",
        "The Death of Artemio Cruz",
        "The Time of the Hero",
        "The Garden of the Finzi-Continis",
        "One Day in the Life of Ivan Denisovich",
        "The Third Wedding",
        "Dog Years",
        "The Bell Jar",
        "Inside Mr. Enderby",
        "The Girls of Slender Means",
        "The Spy Who Came in from the Cold",
        "Manon des Sources",
        "The Graduate",
        "Cat's Cradle",
        "V.",
        "Herzog",
        "The Ravishing of Lol V. Stein",
        "Arrow of God",
        "Come Back, Dr Caligari",
        "Three Trapped Tigers",
        "Sometimes a Great Notion",
        "The Passion According to G.H.",
        "Back to Oegstgeest",
        "Closely Watched Trains",
        "The River Between",
        "Garden, Ashes",
        "- O'Connor, Flannery - Everything That Rises Must Converge",
        "God Bless You, Mr. Rosewater",
        "August is a Wicked Month",
        "Things: A Story of the Sixties",
        "In Cold Blood",
        "Death and the Dervish",
        "Silence",
        "To Each His Own",
        "The Crying of Lot 49",
        "Giles Goat-Boy",
        "Marks of Identity",
        "The Vice-Consol",
        "The Magus",
        "Trawl",
        "The Birds Fall Down",
        "A Man Asleep",
        "The Master and the Margarita",
        "Wide Sargasso Sea",
        "The Third Policeman",
        "Miramar",
        "Z",
        "The Joke",
        "Pilgrimage",
        "The Manor",
        "One Hundred Years of Solitude",
        "The Cubs and Other Stories",
        "Chocky",
        "No Laughing Matter",
        "Day of the Dolphin",
        "The Electric Kool-Aid Acid Test",
        "Eva Trout",
        "The Cathedral",
        "A Kestrel for a Knave",
        "In Watermelon Sugar",
        "The German Lesson",
        "Dark as the Grave Wherein My Friend is Laid",
        "The Quest for Christa T.",
        "Do Androids Dream of Electric Sheep?",
        "2001: A Space Odyssey",
        "Belle du Seigneur",
        "The Nice and the Good",
        "Cancer Ward",
        "Myra Breckinridge",
        "The First Circle",
        "A Void",
        "them",
        "Ada",
        "The Godfather",
        "Portnoy's Complaint",
        "Jacob the Liar",
        "The Green Man",
        "The French Lieutenant's Woman",
        "Slaughterhouse Five",
        "Blind Man with a Pistol",
        "Pricksongs and Descants",
        "Tent of Miracles",
        "The Atrocity Exhibition",
        "The Case Worker",
        "Moscow Stations",
        "Heartbreak Tango",
        "Seasons of Migration to the North",
        "Here's to You, Jesusa",
        "Fifth Business",
        "Play It As It Lays",
        "Jahrestage",
        "Troubles",
        "Mercier and Camier",
        "A World for Julius",
        "I Know Why the Caged Bird Sings",
        "Goalie's Anxiety at the Penalty Kick",
        "The Bluest Eye",
        "The Ogre",
        "The Driver's Seat",
        "The Sea of Fertility",
        "Rabbit Redux",
        "The Wild Boys",
        "Cataract",
        "Group Portrait with Lady",
        "Fear and Loathing in Las Vegas",
        "The Book of Daniel",
        "Lives of Girls and Women",
        "House Mother Normal",
        "In a Free State",
        "Surfacing",
        "G",
        "The Summer Book",
        "The Breast",
        "The Twilight Years",
        "The Optimist's Daughter",
        "Invisible Cities",
        "Sula",
        "The Black Prince",
        "Gravity's Rainbow",
        "The Honorary Consul",
        "Crash",
        "The Castle of Crossed Destinies",
        "The Siege of Krishnapur",
        "A Question of Power",
        "Fear of Flying",
        "Breakfast of Champions",
        "Tinker Tailor Soldier Spy",
        "The Dispossessed",
        "The Diviners",
        "The Lost Honor of Katharina Blum",
        "Dusklands",
        "The Fan Man",
        "The Port",
        "Ragtime",
        "The Commandant",
        "The Year of the Hare",
        "Humboldt's Gift",
        "High Rise",
        "Woman at Point Zero",
        "Willard and His Bowling Trophies",
        "Fateless",
        "The Dead Father",
        "Grimus",
        "Correction",
        "Dead Babies",
        "A Dance to the Music of Time",
        "W, or the Memory of Childhood",
        "Autumn of the Patriarch",
        "Patterns of Childhood",
        "Amateurs",
        "Blaming",
        "Cutter and Bone",
        "Interview with the Vampire",
        "The Public Burning",
        "Ratner's Star",
        "The Left-Handed Woman",
        "Kiss of the Spider Woman",
        "Almost Transparent Blue",
        "In the Heart of the Country",
        "The Engineer of Human Souls",
        "Quartet in Autumn",
        "The Hour of the Star",
        "Song of Solomon",
        "Petals of Blood",
        "The Wars",
        "Dispatches",
        "The Shining",
        "Delta of Venus",
        "The Passion of New Eve",
        "The Beggar Maid",
        "Requiem for a Dream",
        "The Singapore Grip",
        "The Sea, The Sea",
        "Life: A User's Manual",
        "The World According to Garp",
        "The Back Room",
        "The Virgin in the Garden",
        "Yes",
        "The Cement Garden",
        "The Hitchhiker's Guide to the Galaxy",
        "If On a Winter's Night a Traveler",
        "The Safety Net",
        "So Long a Letter",
        "Burger's Daughter",
        "A Bend in the River",
        "Shikasta",
        "A Dry White Season",
        "The Book of Laughter and Forgetting",
        "Fool's Gold",
        "Smiley's People",
        "Southern Seas",
        "The Name of the Rose",
        "City Primeval",
        "Clear Light of Day",
        "Confederacy of Dunces",
        "Rituals",
        "Smell of Sadness",
        "Broken April",
        "Rites of Passage",
        "Midnight's Children",
        "Waiting for the Barbarians",
        "Summer in Baden-Baden",
        "The House with the Blind Glass Windows",
        "Leaden Wings",
        "The War of the End of the World",
        "Lanark",
        "Rabbit is Rich",
        "The Names",
        "Concrete",
        "Couples, Passerby",
        "July's People",
        "The Comfort of Strangers",
        "On the Black Hill",
        "The Newton Letter",
        "The House of Spirits",
        "Schindler's Ark",
        "A Pale View of the Hills",
        "Wittgenstein's Nephew",
        "The Colour Purple",
        "A Boy's Own Story",
        "If Not Now, When?",
        "The Book of Disquiet",
        "Baltasar and Blimunda",
        "The Sorrow of Belgium",
        "The Piano Teacher",
        "The Diary of Jane Somers",
        "The Life and Times of Michael K",
        "Waterland",
        "La Brava",
        "Fools of Fortune",
        "Worstward Ho",
        "The Christmas Oratorio",
        "Fado Alexandrino",
        "The Witness",
        "Shame",
        "Money: A Suicide Note",
        "Flaubert's Parrot",
        "Professor Marten's Departure",
        "Blood and Guts in High School",
        "Larva: Midsummer Night's Babel",
        "Nights at the Circus",
        "Neuromancer",
        "The Wasp Factory",
        "Democracy",
        "The Lover",
        "The Year of the Death of Ricardo Reis",
        "Empire of the Sun",
        "The Busconductor Hines",
        "Dictionary of the Khazars",
        "The Unbearable Lightness of Being",
        "Legend",
        "The Young Man",
        "Love Medicine",
        "White Noise",
        "Old Masters",
        "Half of Man is Woman",
        "Reasons to Live",
        "The Handmaid's Tale",
        "Hawksmoor",
        "Queer",
        "Perfume",
        "Blood Meridian",
        "Contact",
        "Less Than Zero",
        "A Maggot",
        "Simon and the Oaks",
        "The Cider House Rules",
        "Oranges Are Not the Only Fruit",
        "Annie John",
        "The Parable of the Blind",
        "Love in the Time of Cholera",
        "Ancestral Voices",
        "The Beautiful Mrs. Seidenman",
        "The Drowned and the Saved",
        "Foe",
        "Watchmen",
        "Marya",
        "Extinction",
        "An Artist of the Floating World",
        "Memory of Fire",
        "The Old Devils",
        "Matigari",
        "Anagrams",
        "Lost Language of Cranes",
        "The Taebaek Moutains",
        "Ballad for Georg Henig",
        "Enigma of Arrival",
        "World's End",
        "The Pigeon",
        "Of Love and Shadows",
        "Beloved",
        "All Souls",
        "The New York Trilogy",
        "Black Box",
        "The Bonfire of the Vanities",
        "The Black Dahlia",
        "The Passion",
        "The Afternoon of the Writer",
        "The Radiant Way",
        "Kitchen",
        "Dirk Gently's Holistic Detective Agency",
        "The Long Dark Teatime of the Soul",
        "Cigarettes",
        "The Child in Time",
        "Nervous Conditions",
        "The Player of Games",
        "Libra",
        "The First Garden",
        "The Last World",
        "Oscar and Lucinda",
        "The Swimming Pool Library",
        "The Satanic Verses",
        "Wittgenstein's Mistress",
        "The Beautiful Room is Empty",
        "Paradise of the Blind",
        "Foucault's Pendulum",
        "Cat's Eye",
        "The Book of Evidence",
        "Gimmick!",
        "Obabakoak",
        "Inland",
        "A Prayer for Owen Meany",
        "Like Water for Chocolate",
        "History of the Seige of Lisbon",
        "The Trick is to Keep Breathing",
        "The Temple of My Familiar",
        "The Great Indian Novel",
        "The Melancholy of Resistance",
        "Remains of the Day",
        "Billy Bathgate",
        "London Fields",
        "Moon Palace",
        "Sexing the Cherry",
        "A Disaffection",
        "Like Life",
        "A Home at the End of the World",
        "The Buddha of Suburbia",
        "Possession",
        "The Shadow Lines",
        "The Midnight Examiner",
        "The Things They Carried",
        "The Music of Chance",
        "Stone Junction",
        "Amongst Women",
        "Get Shorty",
        "Wise Children",
        "Senor Vivo and the Coca Lord",
        "Downriver",
        "The Daughter",
        "Vertigo",
        "Vineland",
        "American Psycho",
        "The Laws",
        "Faceless Killers",
        "Astradeni",
        "Regeneration",
        "Typical",
        "Mao II",
        "Time's Arrow",
        "Wild Swans",
        "Arcadia",
        "Hideous Kinky",
        "Black Dogs",
        "Memoirs of Rain",
        "Asphodel",
        "The Heather Blazing",
        "Black Water",
        "The Butcher Boy",
        "Smilla's Sense of Snow",
        "Reverte - The Dumas Club",
        "Written on the Body",
        "The Crow Road",
        "Indigo",
        "The English Patient",
        "Jazz",
        "Possessing the Secret of Joy",
        "A Heart So White",
        "All the Pretty Horses",
        "The Triple Mirror of Self",
        "Uncle Petros and Goldbach's Conjecture",
        "The Discovery of Heaven",
        "Life is a Caravanserai",
        "Before Night Falls",
        "The Secret History",
        "The Emigrants",
        "The Robber Bride",
        "The House of Doctor Dee",
        "The Adventures and Misadventures of Maqroll",
        "Remembering Babylon",
        "The Holder of the World",
        "The Virgin Suicides",
        "The Stone Diaries",
        "A Suitable Boy",
        "What a Carve Up!",
        "On Love",
        "Complicity",
        "Operation Shylock",
        "The Twins",
        "Looking for the Possible Dance",
        "Birdsong",
        "Trainspotting",
        "The Shipping News",
        "Waiting for the Dark, Waiting for the Light",
        "The Invention of Curried Sausages",
        "Disappearance",
        "Deep River",
        "Felicia's Journey",
        "Captain Corelli's Mandolin",
        "How Late It Was, How Late",
        "City Sister Silver",
        "Pereira Declares: A Testimony",
        "The Wind-up Bird Chronicle",
        "The Master of Petersburg",
        "Our Lady of the Assassins",
        "Kyung-ni, Park - Land",
        "Whatever",
        "The Folding Star",
        "Mr. Vertigo",
        "Troubling Love",
        "The Late-Night News",
        "The End of the Story",
        "Love's Work",
        "A Fine Balance",
        "The Reader",
        "The Rings of Saturn",
        "Sabbath's Theatre",
        "The Moor's Last Sigh",
        "The Information",
        "Santa Evita",
        "Morvern Callar",
        "The Unconsoled",
        "Alias Grace",
        "The Clay Machine-Gun",
        "Infinite Jest",
        "Forever a Stranger",
        "The Ghost Road",
        "Fugitive Pieces",
        "Hallucinating Foucault",
        "Cocaine Nights",
        "A Light Comedy",
        "MacDonald Ann-Marie - Fall on Your Knees",
        "Silk",
        "The Untouchable",
        "American Pastoral",
        "The God of Small Things",
        "Mason & Dixon",
        "Margot and the Angels",
        "The Life of Insects",
        "Money to Burn",
        "Jack Maggs",
        "Underworld",
        "Enduring Love",
        "Great Apes",
        "Memoirs of a Geisha",
        "Crossfire",
        "The Poisonwood Bible",
        "Veronika Decides to Die",
        "The Hours",
        "Another World",
        "Glamorama",
        "Tipping the Velvet",
        "All Souls Day",
        "Cloudsplitter",
        "Amsterdam",
        "Intimacy",
        "The Heretic",
        "Elementary Particles",
        "Sputnik Sweetheart",
        "The Talk of the Town",
        "Dirty Havana Trilogy",
        "Savage Detectives",
        "Disgrace",
        "The Ground Beneath Her Feet",
        "As If I Am Not There",
        "Cryptonomicon",
        "The Romantics",
        "Timbuktu",
        "Pavel's Letters",
        "In Search of Klingsor",
        "The Museum of Unconditional Surrender",
        "Fear and Trembling",
        "Everything You Need",
        "Pastoralia",
        "Blonde",
        "House of Leaves",
        "Super-Cannes",
        "Vila-Matas, Enrique - Bartleby and Co.",
        "Celestial Harmonies",
        "Nineteen Seventy-Seven",
        "Ignorance",
        "Small Remedies",
        "After The Quake",
        "The Blind Assassin",
        "The Human Stain",
        "How the Dead Live",
        "City of God",
        "White Teeth",
        "Under the Skin",
        "The Heart of Redness",
        "Spring Flowers, Spring Frost",
        "The Devil and Miss Prym",
        "An Obedient Father",
        "The Amazing Adventures of Kavalier and Clay",
        "The Feast of the Goat",
        "I'm Not Scared",
        "Soldiers of Salamis",
        "Atonement",
        "Schooling",
        "Austerlitz",
        "Gabriel's Gift",
        "The Book of Illusions",
        "The Life of Pi",
        "Choke",
        "At Swim, Two Boys",
        "Fury",
        "The Body Artist",
        "Don't Move",
        "The Corrections",
        "Platform",
        "Snow",
        "Nowhere Man",
        "Dead Air",
        "Youth",
        "Middlesex",
        "Shroud",
        "In the Forest",
        "That They May Face the Rising Sun",
        "The Story of Lucy Gault",
        "Everything is Illuminated",
        "The Double",
        "Fingersmith",
        "Family Matters",
        "London Orbital",
        "Elizabeth Costello",
        "Kafka on the Shore",
        "Unless",
        "Islands",
        "The Namesake",
        "Vernon God Little",
        "The Successor",
        "Lady Number Thirteen",
        "The Light of Day",
        "Thursbitch",
        "The Colour",
        "Drop City",
        "The Curious Incident of the Dog in the Night Time",
        "A Tale of Love and Darkness",
        "Your Face Tomorrow",
        "Cloud Atlas",
        "Dining on Stones",
        "The Lambs of London",
        "Vanishing Point",
        "The Swarm",
        "Suite Francaise",
        "The Master",
        "The Plot Against America",
        "The Red Queen",
        "The Book about Blanche and Marie",
        "Small Island",
        "2666",
        "The Line of Beauty",
        "The Accidental",
        "Adjunct: An Undigest",
        "Slow Man",
        "On Beauty",
        "Saturday",
        "Never Let Me Go",
        "The Sea",
        "A Short History of Tractors in Ukrainian",
        "Measuring the World",
        "The History of Love",
        "Mother's Milk",
        "Carry Me Down",
        "Against the Day",
        "The Inheritance of Loss",
        "The Kindly Ones",
        "Half of a Yellow Sun",
        "The Reluctant Fundamentalist",
        "Falling Man",
        "Animal's People",
        "Elegance of the Hedgehog",
        "The Gathering",
        "The Brief Wondrous Life of Oscar Wao",
        "The Blind Side of the Heart",
        "Kieron Smith, Boy",
        "Home",
        "The White Tiger",
        "Cost",
        "Invisible",
        "The Children's Book",
        "American Rust",
        "1Q84",
        "Cain",
        "A Gate at the Stairs",
        "Freedom",
        "Nemesis",
        "The Marriage Plot",
        "The Sense of an Ending",
        "A Visit from the Goon Squad",
        "There but for the",
        "The Art of Fielding",
        "The Goldfinch",
        "The Circle",
        "Americanah",
        "The Flamethrowers",
        "A Girl is a Half-formed Thing",
        "H is for Hawk",
        "10:04",
        "The Story of the Lost Child",
        "Winter",
        "H(A)PPY",
        "Gentlemen Prefer Blondes",
        "Night Boat to Tangier",
        "Tyll",
    ],
}
