"""Unit tests for review exercises."""

import json
import os
import random

from week09 import indent_stars, unindent_stars
from week11 import search_file, strip_file
from week12 import print_stats, track_stats
from week13 import search_json

PATH = os.path.join(os.path.dirname(__file__), "oldtracks.json")

A = """
Quiz 5
* Chapter 9: Sequences
* Chapter 10: File I/O
Quiz 6
* Chapter 11: Nested Data
* Chapter 12: Recursion
"""

B = """
Quiz 5
    * Chapter 9: Sequences
    * Chapter 10: File I/O
Quiz 6
    * Chapter 11: Nested Data
    * Chapter 12: Recursion
"""


def test_indent_stars():
    assert indent_stars(A) == B


def test_unindent_stars():
    assert unindent_stars(B) == A


def test_search_file():
    assert search_file(PATH, "CS149") is None
    assert search_file(PATH, "NOID") == (3, 18)
    assert search_file(PATH, "Rah+Tah+Tah") == (72, 64)
    assert search_file(PATH, "new wave") == (186, 30)
    assert search_file(PATH, "fourteenth") == (1180, 66)


def test_strip_file():
    testfile = "test_ch10.txt"
    line_cnt = 10
    with open(testfile, "w") as file:
        for i in range(line_cnt):
            spaces = random.randint(0, 20)
            file.write(f"Line {i+1}" + " "*spaces + "\n")
    strip_file(testfile)
    with open(testfile) as file:
        lines = file.readlines()
        assert len(lines) == line_cnt
        for i in range(line_cnt):
            assert lines[i] == f"Line {i+1}\n"
    os.remove(testfile)


def test_print_stats(capsys):
    print_stats("Letters:", {"A", "BB", "CCC", "DDD"})
    out, err = capsys.readouterr()
    assert err == ""
    assert out == "Letters: min = 1.0, median = 2.5, mean = 2.2, max = 3.0\n"


def test_track_stats(capsys):
    with open(PATH) as file:
        data = json.load(file)
    track_stats(data)
    out, err = capsys.readouterr()
    assert err == ""
    assert out == (
        "Track names: min = 3.0, median = 11.5, mean = 16.6, max = 59.0\n"
        "Artist names: min = 3.0, median = 10.5, mean = 10.6, max = 18.0\n"
        "Album titles: min = 3.0, median = 12.0, mean = 14.6, max = 39.0\n"
    )


def test_search_json():
    with open(PATH) as file:
        data = json.load(file)
    assert search_json(data, "CS149") is None
    assert search_json(data, "NOID") == 'data[0]["name"]'
    assert search_json(data, "Rah+Tah+Tah") == 'data[1]["url"]'
    assert search_json(data, "new wave") == 'data[2]["toptags"]["tag"][2]["name"]'
    assert search_json(data, "fourteenth") == 'data[19]["wiki"]["summary"]'
