/**
 * Utility functions for manipulating the query string in a URL.
 */

/**
 * Get the value associated with a particular name-value pair in a 
 * query string from a URL.
 *
 * @param  {string} name   The name
 * @return {string}        The value (or null)
 */
function _GET(name)
{
  var regex = new RegExp("[?&]" + name + "=([^&#]*)", "i");
  var value = regex.exec(window.location.href);
  return value ? decodeURIComponent(value[1]) : null;
}